import {Cookie, Local} from "@/utils/storage";

const TokenKey = `ADMIN-TOKEN`;
const UserKey = 'ADMIN-USER—INFO';
const AccessTokenKey = 'ADMIN-ACCESS-TOKEN';


export function getToken() {
  return Cookie.get(TokenKey)
}

export function setToken(token:string) {
  return Cookie.set(TokenKey, token)
}

export function removeToken() {
  return Cookie.remove(TokenKey)
}

export function getAccessToken() {
  return Cookie.get(AccessTokenKey)
}

export function setAccessToken(token:string) {
  return Cookie.set(AccessTokenKey, token)
}

export function removeAccessToken() {
  return Cookie.remove(AccessTokenKey)
}

export function getCacheUserInfo() {
  let data = Local.get(UserKey);
  if (data) {
    data = JSON.parse(decodeURI(data));
  }
  return data || {}
}

export function setCacheUserInfo(data) {
  return Local.set(UserKey, encodeURI(JSON.stringify(data)));
}

export function removeCacheUserInfo() {
  return Local.remove(UserKey);
}
