import { createApp } from 'vue';
import App from './App.vue';
import router from './router';
import { store, key } from './store';
import { directive } from '@/directive';
import element from '@/plugins/element'
import svgIcon from '@/plugins/svgicon'
import other from '@/utils/other';
import linkcom from '@/plugins/linkcom'

import '@/theme/index.scss';
import mitt from 'mitt';

const app = createApp(App);

directive(app);
element(app);
linkcom(app);
svgIcon(app);
other.elSvg(app);

app.use(router)
  .use(store, key)
  .mount('#app');

app.config.globalProperties.mittBus = mitt();
