import request from '@/utils/request';

enum Api {
  listUrl = '/sys/Role/list',
  saveUrl = '/sys/Role/save',
  deleteUrl = '/sys/Role/delete/',
  viewUrl = '/sys/Role/view/',
  changeEnableUrl = '/sys/Role/changeEnable',
  addRoleUserUrl = '/sys/Role/addRoleUser',
  deleteRoleUserUrl = '/sys/Role/deleteRoleUser',
  roleUserlistUrl = '/sys/Role/roleUserlist',
  synPremUrl = '/sys/Role/synPrem/'
}
export function synPrem(serviceName){
  return request({
    url: Api.synPremUrl + serviceName,
    method: 'GET',
  });
}

export function deleteRoleUser(params) {
  return request({
    url: Api.deleteRoleUserUrl,
    method: 'POST',
    data: params,
  });
}

export function addRoleUser(params) {
  return request({
    url: Api.addRoleUserUrl,
    method: 'POST',
    data: params,
  });
}
export function roleUserlist(params) {
  return request({
    url: Api.roleUserlistUrl,
    method: 'POST',
    data: params,
  });
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

