import request from '@/utils/request';

/**
 * 用户登录
 * @param params 要传的参数值
 * @returns 返回接口数据
 */
export function login(params: object) {
	return request({
		url: '/auth/login',
		method: 'post',
		data: params,
	});
}

/**
 * 用户退出登录
 * @param params 要传的参数值
 * @returns 返回接口数据
 */
export function logout(params: object) {
	return request({
		url: '/auth/logout',
		method: 'post',
		data: params,
	});
}

/**
 * 获取菜单路由信息
 */
 export function getDynamicRoutes() {
	return request({
		url: '/sys/Menu/getDynamicRoutes/CUSTOMER_MENU', //CUSTOMER_MENU MANAGE_MENU
		method: 'get',
	});
}


/**
 * 获取验证码
 */
 export function captcha(key) {
	return request({
		url: '/auth/captcha/' + key,
		method: 'GET',
	});
}
