// 声明文件，*.vue 后缀的文件交给 vue 模块来处理
declare module '*.vue' {
  import type { DefineComponent } from 'vue';
  const component: DefineComponent<{}, {}, any>;
  export default component;
}

// 声明文件，定义全局变量。其它 app.config.globalProperties.xxx，使用 getCurrentInstance() 来获取
interface Window {
  nextLoading: boolean;
}

declare interface Fn<T = any> {
  (...arg: T[]): T
}

// 任意对象
declare interface IObj<T = any> {
  [key: string]: T
  [key: number]: T
}

declare type Nullable<T> = T | null

declare interface AxiosConfig {
  params?: any
  data?: any
  url?: string
  method?: 'get' | 'post' | 'delete' | 'put'
  headersType?: string
  responseType?: 'arraybuffer' | 'blob' | 'document' | 'json' | 'text' | 'stream'
}

declare interface Result<T = any>  {
  data: T;
  status: number;
  statusText: string;
  headers: any;
  config: any;
  request?: any;
  code: number;
  msg: string;
}