import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: 'parentId',
      field: 'parentId',
      visible: false,
    },
    {
      title: '职位编码',
      field: 'code',
      width: 130,
      sortable: true,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '职位名称',
      field: 'name',
      sortable: true,
      treeNode: true,
      width: 200,
      query: true,
    },
    {
      title: '所属组织',
      field: 'orgId_alias',
      sortable: true,
      width: 200,
      query: true,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '备注',
      field: 'remake',
      width: 150,
    },
    {
      title: '最后修改时间',
      field: 'lastUpdateTime',
      width: 170,
    },
    {
      title: '最后修改人',
      field: 'lastUpdateUserId_alias',
      width: 150,
    },
  ];
}

export function formSchema(getOrgTreeData : any) :FormSchema[] {
  return [
    {
      field: 'id',
      title: 'id',
      component: 'Input',
      show: false,
    },
    {
      field: 'dataVersion',
      title: 'dataVersion',
      component: 'Input',
      show: false,
    },
    {
      field: 'orgId',
      title: '所属组织',
      component: 'TreeSelect',
      required: true,
      componentProps:{
        api: getOrgTreeData,
        serviceName: 'link-system-start',
        props: {
          value: 'id',
          label: 'name',
        },
        filterable: true,
        clearable: true,
      }
    },
    {
      field: 'code',
      title: '职位编码',
      required: false,
      placeholder: '保存自动生成',
      component: 'Input',
    },
    {
      field: 'name',
      title: '职位名称',
      required: true,
      component: 'Input',
    },
    {
      field: 'parentId',
      title: '上级职位',
      component: 'BindDict',
      componentProps: () => {
        return {
          type: 'TreeSelect',
          billVo: 'com.link.jiandanbiao.sys.vo.PositionVo',
          serviceName: 'link-system-start',
          fields: 'id,name',
          dynFilter: `is_enable = 1`,
          props: {
            label: 'name',
            value: 'id',
          },
          clearable: true
        }
      }
    },
    {
      field: 'isEnable',
      title: '状态',
      component: 'RadioGroup',
      required: true,
      componentProps: {
        options: [
          { label: '启用', value: 1 },
          { label: '禁用', value: 0 },
        ],
      },
    },
    {
      field: 'remake',
      title: '备注',
      component: 'Input',
      componentProps:{
        type: 'textarea'
      }
    },
  ]
};


