import { TableColumnSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'

export function listColumns(): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '用户编码',
      field: 'userNumber',
      width: 100,
    },
    {
      title: '用户实名',
      field: 'userName',
      width: 100,
      align: 'left',
    },
    {
      title: '所属职位',
      field: 'positopnName',
      width: 100,
      align: 'left',
    },
    {
      title: '所属组织',
      field: 'orgId',
      width: 100,
      align: 'left',
    },
    {
      title: 'sessionId',
      field: 'sessionId',
      width: 200,
    },
    {
      title: '过期时间',
      field: 'expires',
      width: 100,
      align: 'right',
    },
    {
      title: '账号来源',
      field: 'source',
      align: 'left',
      renderCustom: ({row}) =>{
        return h(ElTag,{},row.source === 'SYS'? '系统预设': row.source === 'INPUT'? '手工新建': row.source)
      }
    },
  ];
}
