import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: 'APP ID',
      field: 'appId',
      width: 100,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'appId');
      }
    },
    {
      title: 'APP SECRET',
      field: 'appSecret',
      sortable: true,
      width: 200,
      align: 'left',
    },
    {
      title: '是否启用',
      field: 'isEnable',
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '调用周期',
      field: 'periodRange',
      sortable: true,
      width: 200,
      align: 'left',
    },
    {
      title: '绑定用户',
      field: 'bindUser_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '备注',
      field: 'remake',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: 'IP白名单',
      field: 'ipWhiteList',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 160,
      align: 'left',
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'appId',
    title: 'APP ID',
    required: true,
    component: 'Input',
    disabled: ({model}) => !!model.id
  },
  {
    field: 'appSecret',
    title: 'SECRET',
    required: true,
    component: 'Input',
  },
  {
    field: 'periodRange',
    title: '调用周期',
    //helpMessage: '只能在此期间内调用，不填则不受控制',
    component: 'DatePicker',
    required: true,
    colProps: 24,
    componentProps: {
      type: 'daterange',
      valueFormat: 'YYYY-MM-DD'
    }
  },
  {
    field: 'bindUser',
    title: '绑定用户',
    required: true,
    //helpMessage: '不绑定则有所有接口权限，绑定用户则权限按绑定用户走，建议绑定',
    component: 'BindEntity',
    componentProps: () =>({ //样例演示，请结合实际业务改动
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'name,phone,email',
      serviceName: 'link-system-start',
      dynFilter: 'is_enable = 1',
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
    })
  },
  {
    field: 'ipWhiteList',
    title: 'IP白名单',
    helpMessage: '多个IP地址用英文逗号隔开',
    component: 'Input',
    colProps: 24,
    componentProps: {
      type: 'textarea'
    }
  },
  {
    field: 'remake',
    title: '备注',
    component: 'Input',
    colProps: 24,
    componentProps: {
      type: 'textarea'
    }
  },
];


