import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle } from '@/views/common/utils';

export function listColumns(showDetail: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '任务名称',
      field: 'name',
      query: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'name');
      }
    },
    {
      title: '运行状态',
      field: 'runStatus',
      width: 100,
      renderCustom: ({ row }) => {
        return h(ElTag,{}, 0 === row.runStatus? '进行中': '已完成');
      }
    },
    {
      title: '类型',
      field: 'types',
      width: 70,
      renderCustom: ({ row }) => {
        return h(ElTag,{}, row.types);
      }
    },
    {
      title: '状态',
      field: 'status',
      query: {
        component: 'RadioGroup',
        componentProps:{
          options: [
            {label: '全部'},
            {label: '成功', value: 1},
            {label: '失败', value: 0},
          ]
        }
      },
      width: 70,
      renderCustom: ({ row }) => {
        return h(ElTag,{type: 1 === row.status?'success':'danger'}, 1 === row.status? '成功': '失败');
      }
    },
    {
      title: '执行结果',
      field: 'result',
      width: 120,
      showOverflow: "ellipsis"
    },
    {
      title: '错误日志',
      field: 'errMsg',
      width: 120,
      showOverflow: "ellipsis"
    },
    {
      title: '开始时间',
      field: 'startTime',
      sortable: true,
      query: {
        component: 'DatePicker',
        queryType: 'BETWEEN',
        componentProps:{
          type: 'daterange'
        },
        queryType: 'BETWEEN'
      },
      width: 170,
    },
    {
      title: '结束时间',
      field: 'endTime',
      sortable: true,
      width: 170,
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'name',
    title: '任务名称',
    component: 'Input',
  },
  {
    field: 'types',
    title: '类型',
    component: 'Input',
    formatter: ({ model }) => {
      return h(ElTag,{}, model.types);
    }
  },
  {
    field: 'status',
    title: '执行结果',
    component: 'Input',
    formatter: ({ model }) => {
      return h(ElTag,{type: 1 === model.status?'success':'danger'}, 1 === model.status? '成功': '失败');
    }
  },
  {
    field: 'className',
    title: '执行类',
    component: 'Input',
  },
  {
    field: 'methodName',
    title: '执行方法',
    component: 'Input',
  },
  {
    field: 'url',
    title: '执行URL',
    component: 'Input',
  },
  {
    field: 'params',
    title: '执行参数',
    component: 'Input',
  },
  {
    field: 'startTime',
    title: '开始时间',
    component: 'DatePicker',
  },
  {
    field: 'endTime',
    title: '结束时间',
    component: 'DatePicker',
  },
  {
    field: 'runTime',
    title: '任务执行时间',
    component: 'InputNumber',
  },
  {
    field: 'errMsg',
    title: '错误日志',
    component: 'Input',
  },
];

