import { TableColumnSchema } from 'link-components';

export const listColumns: TableColumnSchema[] =[
  {type: 'seq',title: '序号', width: 60},
  {
    title: '文件名称',
    field: 'name',
    query: true,
    sortable: true,
    width: 200,
  },
  {
    title: '业务ID',
    field: 'billId',
    query: true,
    resizable: true,
    sortable: true,
    visible: false,
    width: 100,
  },
  {
    title: '空间/名称',
    field: 'fileName',
    sortable: true,
    width: 170,
  },
  {
    title: '附件大小',
    field: 'fileSize',
    sortable: true,
    width: 100,
  },
  {
    title: '附件分类',
    field: 'relType',
    sortable: true,
    width: 100,
  },
  {
    title: '上传人',
    field: 'lastUpdateUserId_alias',
    width: 100,
  },
  {
    title: '上传时间',
    field: 'lastUpdateTime',
    sortable: true,
    query: {
      component: 'DatePicker',
      queryType: 'BETWEEN',
      componentProps:{
        type: 'daterange'
      },
    },
    width: 170,
  },
];
