import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60, visible: true},
    {
      title: '编号',
      field: 'code',
      width: 100,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
      {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 160,
      align: 'left',
    },
    {
      title: '最后更新人名称',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '最后更新人编码',
      field: 'lastUpdateUserId_code',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '名称',
      field: 'name',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '编码',
      field: 'code',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '金额',
      field: 'amount',
      sortable: true,
      width: 100,
      align: 'right',
    },
    {
      title: '供应商',
      field: 'supplier_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '物料名称',
      field: 'orderBillEenty.material',
      width: 100,
      align: 'right',
    },
    {
      title: '单价',
      field: 'orderBillEenty.price',
      width: 100,
      align: 'right',
    },
    {
      title: '数量',
      field: 'orderBillEenty.numberbox',
      width: 100,
      align: 'right',
    },
    {
      title: '金额',
      field: 'orderBillEenty.amount',
      width: 100,
      align: 'right',
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'name',
    title: '名称',
    component: 'Input',
  },
  {
    field: 'code',
    title: '编码',
    component: 'Input',
  },
  {
    field: 'supplier',
    title: '供应商',
    component: 'BindEntity',
    componentProps: ({formModel}) =>({ //样例演示，请结合实际业务改动
      billVo: 'com.link.jiandanbiao.demo.vo.SupperVo',
      fields: 'id,name',
      dynFilter: ``,
      multiple: true,
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: []
    })
  },
  {
    field: 'amount',
    title: '金额',
    component: 'Input',
    componentProps: {
      type: "number",
      precision: 2,
      minusAble: false,
    }
  },
  {
    field: 'sType',
    title: '类型',
    component: 'Input',
  },
];

export const tableOrderBillEenty: TableColumnSchema[] = [
  {
    field: 'material',
    title: '物料',
    width: 130,
    editRender: {
      component: 'Input',
    }
  },
  {
    field: 'price',
    title: '单价',
    width: 130,
    editRender: {
      component: 'Input',
      componentProps: {
        type: "number",
        precision: 2,
        minusAble: false,
      }
    }
  },
  {
    field: 'numberbox',
    title: '数量',
    width: 130,
    editRender: {
      component: 'Input',
      componentProps: {
        type: "number",
        precision: 2,
        minusAble: false,
      }
    }
  },
  {
    field: 'amount',
    title: '金额',
    width: 130,
    editRender: {
      component: 'Input',
      componentProps: ({row}) =>{
        return {
          type: "number",
          precision: 2,
          minusAble: false,
          onChange: (value: any)=>{
            row.status = '002';
          }
        }
      }
    }
  },
  {
    field: 'status',
    title: '状态',
    width: 130,
    editRender: {
      component: 'BindDict',
      componentProps: {
        type: 'Select',
        apiType: 'dict',
        dictGroup: 'test',
        props: {
          label: 'label',
          value: 'value',
        }
      }
    }
  }
];

