import type {TableColumnSchema} from "link-components";

export function listColumns(): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: 'Input',
      field: 'input',
      width: 100,
      editRender: {
        defaultValue: '11111',
        component: 'Input',
        componentProps: {
        }
      }
    },
    {
      title: 'date',
      field: 'date',
      editRender: {
        component: 'DatePicker',
        componentProps: {
          valueFormat: 'YYYY-MM-DD'
        }
      }
    },
    {
      field: 'number',
      title: '数字输入框',
      editRender: {
        component: 'Input',
        componentProps: {
          type: 'number',
          placeholder: '限制两位小数',
          precision: 2
        }
      }
    },
    {
      field: 'email',
      title: 'email输入框',
      editRender: {
        component: 'Input',
        componentProps: {
          type: 'email'
        }
      }
    },
    {
      field: 'phone',
      title: 'phone输入框',
      editRender: {
        component: 'Input',
        componentProps: {
          type: 'phone'
        }
      }
    },
    {
      field: 'password',
      title: '密码框',
      editRender: {
        component: 'Input',
        componentProps: {
          type: 'password',
          showPassword: true
        }
      }
    },
    {
      field: 'inputNumber',
      title: 'InputNumber',
      editRender: {
        component: 'InputNumber',
        componentProps: {
          precision: 2
        }
      }
    },
    {
      title: 'textarea',
      field: 'textarea',
      editRender: {
        component: 'Input',
        componentProps: {
          type: 'textarea',
          maxlength: 500,
          showWordLimit: true,
        }
      }
    },
  ];
}
export function dictColumns(): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      field: 'dictTreeSelect',
      title: 'Dict树型下拉',
      width: 200,
      editRender: {
        component: 'BindDict',
        componentProps: {
          type: 'TreeSelect',
          teleported: false,
          billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
          fields: 'id,title',
          props: {
            label: 'title',
            value: 'id',
            formatter: (data) => {
              return `名称：${data.title || '-'}`
            }
          }
        }
      }
    },
    {
      field: 'dictTreeSelect2',
      title: '树型多选限制',
      width: 200,
      editRender: {
        component: 'BindDict',
        componentProps: {
          type: 'TreeSelect',
          teleported: false,
          multiple: true,
          multipleLimit:3,
          billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
          fields: 'id,title',
          props: {
            label: 'title',
            value: 'id',
            formatter: (data) => {
              return `名称：${data.title || '-'}`
            }
          }
        }
      }
    },
    {
      field: 'dictSelect',
      title: 'Dict下拉',
      width: 200,
      editRender: {
        component: 'BindDict',
        componentProps: (data) => {
          console.log(data, '====row')
          return {
            type: 'Select',
            teleported: false,
            billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
            fields: 'id,name,phone,email',
            props: {
              label: 'name',
              value: 'id',
              formatter: (data) => {
                return `姓名：${data.name || '-'}`
              }
            }
          }
        }
      }
    },
    {
      field: 'dictSelect2',
      title: '下拉多选限制',
      width: 200,
      editRender: {
        component: 'BindDict',
        componentProps: () => {
          return {
            type: 'Select',
            teleported: false,
            multiple: true,
            multipleLimit: 3,
            billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
            fields: 'id,name,phone,email',
            props: {
              label: 'name',
              value: 'id',
              formatter: (data) => {
                return `姓名：${data.name || '-'}`
              }
            }
          }
        }
      }
    },
    {
      field: 'dictRadio',
      title: 'DictRadio',
      width: 150,
      editRender: {
        component: 'BindDict',
        componentProps: {
          type: 'Radio',
          billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
          fields: 'id,name,phone,email',
          dynFilter: "name like '%dst%'",
          props: {
            label: 'name',
            value: 'id',
            formatter: (data) => {
              return `姓名：${data.name || '-'}`
            }
          }
        }
      }
    },
    {
      field: 'dictCheckbox',
      title: 'DictCheckbox',
      width: 150,
      editRender: {
        component: 'BindDict',
        defaultValue: [],
        componentProps: {
          type: 'Checkbox',
          boxStyle: 'checkbox',
          billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
          fields: 'id,name,phone,email',
          dynFilter: "name like '%3%'",
          props: {
            label: 'name',
            value: 'id',
            formatter: (data) => {
              return `姓名：${data.name || '-'}`
            }
          }
        }
      }
    },
    // {
    //   field: 'dictCascader',
    //   title: 'DictCascader',
    //   width: 200,
    //   editRender: {
    //     component: 'BindDict',
    //     componentProps: {
    //       type: 'Cascader',
    //       billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
    //       fields: 'id,title',
    //       props: {
    //         label: 'title',
    //         value: 'id',
    //         formatter: (data) => {
    //           return `名称：${data.title || '-'}`
    //         }
    //       }
    //     }
    //   }
    // },
    // {
    //   field: 'dictCascader2',
    //   title: 'Cascader多选',
    //   width: 200,
    //   editRender: {
    //     component: 'BindDict',
    //     componentProps: {
    //       type: 'Cascader',
    //       billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
    //       fields: 'id,title',
    //       props: {
    //         label: 'title',
    //         value: 'id',
    //         multiple: true,
    //         formatter: (data) => {
    //           return `名称：${data.title || '-'}`
    //         }
    //       }
    //     }
    //   }
    // },
    // {
    //   field: 'user',
    //   title: 'BindEntity',
    //   width: 200,
    //   editRender: {
    //     component: 'BindEntity',
    //     componentProps: () =>({
    //       billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
    //       fields: 'id,name,phone,email',
    //       queryFields: 'name',
    //       props: {
    //         label: 'name',
    //         value: 'id'
    //       },
    //       columns: [
    //         {
    //           title: '电话号码',
    //           field: 'email',
    //           formatter: ({cellValue}) => {
    //             return `${cellValue || 'x'}@10086.con`
    //           }
    //         }
    //       ]
    //     })
    //   }
    // },
    // {
    //   field: 'user2',
    //   title: 'databox多选',
    //   width: 200,
    //   editRender: {
    //     component: 'BindEntity',
    //     componentProps: () =>({
    //       billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
    //       fields: 'id,name,phone,email',
    //       queryFields: 'name',
    //       multiple: true,
    //       props: {
    //         label: 'name',
    //         value: 'id'
    //       },
    //       columns: [
    //         {
    //           title: '电话号码',
    //           field: 'email',
    //           formatter: ({cellValue}) => {
    //             return `${cellValue || 'x'}@10086.con`
    //           }
    //         }
    //       ]
    //     })
    //   }
    // },
  ];
}
