import { h } from 'vue';
import { ElSwitch, ElButton } from 'element-plus'
import { Session } from '@/utils/storage';
/**
 * 构建打开详情页h函数
 * @param showDetail
 * @param record
 * @param field
 * @returns
 */
 export function createOpenTitle (showDetail: Function,row: any,field : any) {
  return h( 'div', [
    h('a',{
      style: {
        fontWeight: 'bold',
        textOverflow: 'ellipsis',
        display: 'block',
        overflow: 'hidden',
        color: 'blue'
      },
      onclick: ()=>{
        showDetail(row)
      }
    }, row[field])
  ])
}

/**
 * 构建列表 启用禁用按钮组件
 * @param handleChangeStatus
 * @param record
 * @returns
 */
export function createSwitch (handleChangeStatus: Function,row: any) {
  return h( ElSwitch, {
    modelValue: row.isEnable === 1 ,
    size: 'small',
    onclick:()=>{
      handleChangeStatus(row);
    }
  })
}

export function getWfRootUrl() {
  const rootUrl = import.meta.env.VITE_API_URL as string;
  if(rootUrl === '/api/'){
    if(window.location.pathname.includes('/api/')){
      return `/api/workflow.html#/`
    }
    return `/workflow.html#/`
  }
  return 'http://localhost:3020/#/'
}

/**
 * 查看流程图
 * @param orderId 
 */
export function viewWfProcessChart(orderId: String){
  return h(ElButton,{type: 'primary', size: 'small', onClick: ()=>{
    window.open(`${getWfRootUrl()}view?orderId=${orderId}&token=${Session.get('access-token')}`)
  }},'点击查看');
}

/**
 * 新增流程图
 * @param processId 
 */
 export function createProcessChart(processId){
  window.open(`${getWfRootUrl()}design?token=${Session.get('access-token')}&processId=${processId?processId:''}`)
}

/**
 * 打开审批页面
 * @param taskId 
 */
export function openApprovePage(taskId: any){
  window.open(`${getWfRootUrl()}approve?token=${Session.get('access-token')}&taskId=${taskId}`)
}


/**
 * 打开表单页面
 * @param taskId 
 */
 export function openApproveBillPage(taskId: any){
  window.open(`${getWfRootUrl()}approve?token=${Session.get('access-token')}&showBill=true&taskId=${taskId}`)
}