import { TableColumnSchema, DescItem } from 'link-components';

export function filedSchema(): DescItem[] {
  return [{
    title: '属性名称',
    field: 'name',
    width: 80,
    minWidth: 80
  },{
    title: '属性别名',
    field: 'alias',
    width: 80,
    minWidth: 80
  },{
    title: '关联实体',
    field: 'referenceInfo',
  },{
    title: '字段类型',
    field: 'fieldType',
  },{
    title: '数据字典',
    field: 'dict',
  }]
}
export function listColumns(): TableColumnSchema[]{
  return [
    { width: 60, field: 'drag' , title: '调序', fixed: 'left'},
    {
      title: 'isMain',
      field: 'isMain',
      width: 100,
      visible: false
    },
    {
      title: '实体路径',
      field: 'entityPath',
      width: 130,
      visible: false
    },
    {
      title: '表单名称',
      field: 'name',
      width: 150,
      visible: false
    },
    {
      title: '字段名称',
      field: 'fieldName',
      fixed: 'left',
      treeNode: true,
      width: 160,
      renderCustom: ({row})=>{
        const fieldName = row.fieldName;
        return row.groupName?fieldName.replace(row.groupName+'.',''):fieldName;
      }
    },
    {
      title: '字段别名',
      field: 'fieldTitle',
      width: 100,
      editRender: {
        component: 'Input'
      }
    },
    {
      title: '值格式化',
      field: 'formatRule',
      width: 100,
      editRender: {
        component: 'Select',
        componentProps: ({row}) =>{
          let dynOptions = [] as any;
          if('DATE' === row.fieldType){
            dynOptions = [
              {label: 'yyyy-MM-dd', value: 'yyyy-MM-dd'},
              {label: 'yyyyMMdd', value: 'yyyyMMdd'},
              {label: 'yyyy-MM', value: 'yyyy-MM'},
              {label: 'yyyyMM', value: 'yyyyMM'},
              {label: 'yyyy-MM-dd HH:mm:ss', value: 'yyyy-MM-dd HH:mm:ss'},
              {label: 'yyyyMMddHHmmss', value: 'yyyyMMddHHmmss'},
            ] 
          }
          if('INT' === row.fieldType || 'BOOL' === row.fieldType){
            dynOptions = [
              {label: '无格式', value: ''},
              {label: '###,###', value: '###,###'},
              {label: '按Boolean格式', value: 'BOOLEAN'},
            ] 
          }
          if('DECIMAL' === row.fieldType){
            dynOptions = [
              {label: '无格式', value: ''},
              {label: '###.0', value: '###.0'},
              {label: '###.00', value: '###.00'},
              {label: '###.000', value: '###.000'},
              {label: '###.0000', value: '###.0000'},
              {label: '###.00000', value: '###.00000'},
              {label: '###.000000', value: '###.000000'},
              {label: '###,###.0', value: '###,###.0'},
              {label: '###,###.00', value: '###,###.00'},
              {label: '###,###.000', value: '###,###.000'},
              {label: '###,###.0000', value: '###,###.0000'},
              {label: '###,###.00000', value: '###,###.00000'},
              {label: '###,###.000000', value: '###,###.000000'},
            ] 
          }
          return {
            options: dynOptions,
            props: {
              label: 'label',
              value: 'value'
            }
          }
        }
      }
    },
    {
      title: '字段宽度',
      field: 'fieldWidth',
      width: 120,
      titleHelp: {content: '表头字段请按24等份配置(不设置默认宽度为8)，分录或子表请按列宽设置单位为px(不设置时默认宽度为100px)'},
      editRender: {
        component: 'Input',
        componentProps: {
          type: "number",
          precision: 0,
          minusAble: false,
        }
      }
    },
    {
      title: '数据字典',
      field: 'dictCode',
      width: 100,
    },
    {
      title: '关联实体',
      field: 'relationEntityPath',
      width: 100,
      visible: false
    },
    {
      title: '字段类型',
      field: 'fieldType',
      width: 100,
    },
    {
      title: '序号',
      field: 'seq',
      width: 50,
    },
    {
      title: '所属分组',
      field: 'groupName',
      width: 100,
      visible: false
    },
  ]
}