import {Module} from 'vuex';
import {RootStateTypes, AppState} from '@/store/types';
import {RouteRecordRaw} from "vue-router";

const appModule: Module<AppState, RootStateTypes> = {
  namespaced: true,
  state: {
    collapse: false,
    navRoutes: [],
    menuRoutes: [],
  },
  mutations: {
    SET_COLLAPSE: (state, collapse) => {
      state.collapse = collapse;
    },
    CHANGE_COLLAPSE: (state) => {
      state.collapse = !state.collapse;
    },
    SET_NAV_ROUTES: (state, navRoutes) => {
      state.navRoutes = navRoutes;
    },
    SET_MENU_ROUTES: (state, menuRoutes) => {
      state.menuRoutes = menuRoutes;
    },
  },
  actions: {
    setCollapse({ commit }, collapse: boolean) {
      commit('SET_COLLAPSE', collapse)
    },
    changeCollapse({ commit }) {
      commit('CHANGE_COLLAPSE')
    },
    setNavRoutes({ commit }, navRoutes: []) {
      commit('SET_NAV_ROUTES', delChildren(filterShowMenus(navRoutes)))
    },
    setMenuRoutes({ commit }, menuRoutes: []) {
      commit('SET_MENU_ROUTES', filterShowMenus(menuRoutes))
    }
  },
};

export function filterShowMenus(arr: Array<RouteRecordRaw>): Array<RouteRecordRaw> {
  return arr
    .filter(item => !item.meta || !item.meta.isHide)
    .map(item => {
      item = Object.assign({}, item);
      if (item.children) {
        item.children = filterShowMenus(item.children);
      }
      return item;
    });
}

export function delChildren(arr: Array<object>) {
  arr.forEach((v: any) => {
    if (v.path === '/' && v.redirect) {
      v.path = v.redirect
    }
    if (v.children) delete v.children;
  });
  return arr;
}

export default appModule;
