

let dynamicViewsModules: Record<string, () => Promise<any>>;

export function toRouterBase(menuData : any){
  dynamicViewsModules = dynamicViewsModules || import.meta.glob('../views/**/*.{vue,tsx}');
  menuData.forEach(async (route) => {
    if(route.meta){
      route.meta.isKeepAlive = route.meta.keepAlive;
      route.meta.isHide = route.meta.hide;
      route.meta.isAffix = route.meta.affix;
      route.meta.isIframe = route.meta.iframe;
    }
    if (route.component) {
      if('Layout' === route.component){
        route.component = () => import('@/layout/index.vue');
      } else if('Blank' === route.component){
        route.component = () => import('@/layout/routerView/Blank.vue');
      } else if(route.meta.isIframe){
        route.meta.isLink = route.component;
        route.component = () => import('@/layout/routerView/Iframe.vue');
      } else if("true" === route.meta.isLink){
        route.meta.isLink = route.component;
        route.component = () => import('@/layout/routerView/link.vue');
      } else{
        route.component = dynamicImport(dynamicViewsModules, route.component);
        // try {
        //   if (comFun) {
        //     const module = await comFun();
        //     if (module && module.default) {
        //       route.name = module.default.name
        //     }
        //   }
        // } catch (e) {
        //   console.warn(e, '路由名称无效');
        // }
      }
    }
    if(route.children){
      route.children = genChildrenRouter(route.children, route.name);
    }
  });
  return menuData;
}

function genChildrenRouter(children: any[], parentRouterName: string){
  children.forEach(async (route) => {
    if(route.meta){
      route.meta.isKeepAlive = route.meta.keepAlive;
      route.meta.isHide = route.meta.hide;
      route.meta.isAffix = route.meta.affix;
      route.meta.isIframe = route.meta.iframe;
    }
    if('Layout' === route.component){
      route.component = () => import('@/layout/index.vue');
    } else if('Blank' === route.component){
      route.component = () => import('@/layout/routerView/Blank.vue');
    } else if(route.meta.isIframe){
      route.meta.isLink = route.component;
      route.component = () => import('@/layout/routerView/Iframe.vue');
    } else if("true" === route.meta.isLink){
      route.meta.isLink = route.component;
      route.component = () => import('@/layout/routerView/link.vue');
    } else{
      route.component = dynamicImport(dynamicViewsModules, route.component);
      // try {
      //   if (comFun) {
      //     const module = await comFun();
      //     if (module && module.default) {
      //       route.name = module.default.name
      //     }
      //   }
      // } catch (e) {
      //   console.warn(e, '路由名称无效');
      // }
    }
    if(route.children){
      route.children = genChildrenRouter(route.children, route.name);
    }
    if (route.name.startsWith(parentRouterName)) {
      route.name = route.name.replace(parentRouterName, '')
    }
  });
  return children;
}

function dynamicImport(
  dynamicViewsModules: Record<string, () => Promise<any>>,
  component: string
) {
  const keys = Object.keys(dynamicViewsModules);
  const matchKeys = keys.filter((key) => {
    let k = key.replace('../views', '');
    const lastIndex = k.lastIndexOf('.');
    k = k.substring(0, lastIndex);
    return k === component;
  });
  if (matchKeys?.length === 1) {
    const matchKey = matchKeys[0];
    return dynamicViewsModules[matchKey];
  }
  if (matchKeys?.length > 1) {
    return;
  }
}
