import {nextTick} from 'vue';
import {store} from '@/store'
import type {Router} from "vue-router";

/**
 * 关闭当前菜单且返回上一菜单
 */
export function pageBack(router: Router) {
  store.dispatch('tagsView/delView', router.currentRoute.value);
  router.go(-1);
}

/**
 * 刷新当前页面
 */
export function refreshCurrent(router: Router, query: {[key:string]: any}) {
  store.dispatch('tagsView/delCachedView', router.currentRoute.value).then(() => {
    nextTick(() => {
      const {path} = router.currentRoute.value;
      router.replace({
        path: '/redirect' + path,
        query: query
      })
    })
  })
}

/**
 * 拼接详情页路由地址
 * @param router 
 * @param detailName 
 * @returns 
 */
export function goDetailPath(router: any, detailName: any){
  const path = router.currentRoute.value.path;
  return `${path.substring(0,path.lastIndexOf('/'))}/${detailName}`
}