export {};

declare module 'vue-router' {
  interface RouteMeta extends Record<string | number | symbol, unknown> {
    // 菜单栏及 tagsView 栏、菜单搜索名称（国际化）
    title?: string,
    // 是否超链接菜单，开启外链条件，`1、isLink:true 2、链接地址不为空`
    isLink?: boolean | string,
    //  是否隐藏此路由
    isHide?: boolean,
    // 是否缓存组件状态
    isKeepAlive?: boolean,
    // 是否固定在 tagsView 栏上
    isAffix?: boolean,
    // 是否内嵌窗口，，开启条件，`1、isIframe:true 2、链接地址不为空`
    isIframe?: boolean,
    // 菜单、tagsView 图标，svg图标名称
    icon?: string,
    // 不显示页签
    noTagsView?: boolean,
  }
}
