import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '编号',
      field: 'code',
      width: 100,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
      {
      title: '最后更新人ID',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: 'checkboxGroup组',
      field: 'checkboxGroup',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '用户组',
      field: 'users_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
      {
      title: '测试字典',
      field: 'dict_alias',
      sortable: true,
      width: 120,
      align: 'left',
      },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'name',
    title: '名称',
    component: 'Input',
  },
  {
    field: 'code',
    title: '编码',
    component: 'Input',
  },
  {
    field: 'testBindEntity',
    title: 'BindEntity',
    component: 'Input',
  },
  {
    field: 'checkboxGroup',
    title: 'checkboxGroup组',
    component: 'CheckboxGroup',
    componentProps: {
      options: [ //请自己调整为BindDic 或BindEntity
        {label: '菜单', value: 'menu'},
        {label: '权限项', value: 'button'},
      ]
    }
  },
  {
    field: 'users',
    title: '用户组',
    component: 'BindEntity',
    componentProps: ({formModel}) =>({ //样例演示，请结合实际业务改动
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      fields: 'id,name',
      dynFilter: ``,
      multiple: true,
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: []
    })
  },
  {
    field: 'dict',
    title: '测试字典',
    component: 'BindDict',
    componentProps: {
      type: 'checkbox',
      apiType: 'dict',
      multiple: true,
      dictGroup: '111',
      props: {
        label: 'label',
        value: 'value',
      }
    }
  },
  {
    field: 'entitytest',
    title: '实体字典',
    component: 'BindDict',
    componentProps: ({formModel}) => {
      return {
        type: 'Select',
        billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
        fields: 'id,name',
        multiple: false,
        dynFilter: '',
        props: {
          label: 'name',
          value: 'id',
          formatter: (data) => {
          return data.name
          }
        }
      }
    }
  },
];

export const tabletestEe: TableColumnSchema[] = [
  {
    field: 'name',
    title: '名称',
    width: 130,
    editRender: {
      component: 'Input',
    }
  },
];

