import request from '@/utils/request';

enum Api {
  listUrl = '/sys/Org/list',
  saveUrl = '/sys/Org/save',
  deleteUrl = '/sys/Org/delete/',
  viewUrl = '/sys/Org/view/',
  changeEnableUrl = '/sys/Org/changeEnable',
  getOrgTreeDataUrl = '/sys/Org/getOrgTreeData',
  getOrgPisitionAndPersonTreeDataUrl = '/sys/Org/getOrgPisitionAndPersonTreeData',
}
export function getOrgPisitionAndPersonTreeData(params) {
  return request({
    url: Api.getOrgPisitionAndPersonTreeDataUrl,
    method: 'POST',
    data: params,
  });
}
export function getOrgTreeData() {
  return request({
    url: Api.getOrgTreeDataUrl,
    method: 'GET',
  });
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

