import request from '@/utils/request';
import {guid} from '@/utils/commonFunction'
enum Api {
  listUrl = '/bpm/wfType/list',
  treeUrl = '/bpm/wfType/tree',
  saveUrl = '/bpm/wfType/save',
  deleteUrl = '/bpm/wfType/delete/',
  viewUrl = '/bpm/wfType/view/',
  changeEnableUrl = '/bpm/wfType/changeEnable',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function getTreeData(params) {
  return request({
    url: Api.treeUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

export function getId() {
  return 'XFJFB' + guid();
}
