import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '租户编号',
      field: 'code',
      width: 100,
      sortable: true,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '租户名称',
      field: 'name',
      query: true,
      sortable: true,
      width: 140,
      align: 'left',
    },
    {
      title: '是否启用',
      field: 'isEnable',
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '使用期间',
      field: 'periodRange',
      sortable: true,
      width: 200,
      align: 'left',
    },

    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 170,
      align: 'left',
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '租户编码',
    required: true,
    component: 'Input',
  },
  {
    field: 'name',
    title: '租户名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'periodRange',
    title: '使用期间',
    component: 'DatePicker',
    required: true,
    colProps: 24,
    componentProps: {
      type: 'daterange',
      valueFormat: 'YYYY-MM-DD'
    }
  },
  {
    field: 'isEnable',
    title: '状态',
    component: 'RadioGroup',
    required: true,
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
];


