import {FormSchema, TableColumnSchema} from 'link-components';
import {h} from "vue";
import { ElTag } from 'element-plus'
import { viewWfProcessChart } from '@/views/common/utils';
import XEUtils from "xe-utils";

export function listColumns(): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 50},
    {
      title: 'assignCode_alias',
      field: 'assignCode_alias',
      visible: false,
    },
    {
      title: '状态',
      field: 'taskState_alias',
      hide: true
    },
    {
      title: '任务状态',
      field: 'taskState',
      width: 100,
      renderCustom: ({row}) => {
        // @ts-ignore
        return row.taskState_alias ? h(ElTag,{type: row.taskState === 'Completed' ? 'success' : (row.taskState === 'Todo'?'primary': 'danger')}, {
          default: () => row.taskState_alias
        }): ''
      },
      query: {
        component: 'Select',
        componentProps: {
          clearable: true,
          options: [
            {
              label: '已完成',
              value: 'Completed'
            },
            {
              label: '待处理',
              value: 'Todo'
            },
          ],
          props: {
            label: 'label',
            value: 'value',
          }
        }
      },
    },
    {
      title: '流程图',
      field: 'process_view',
      width: 100,
      renderCustom: ({row})=>{
        return viewWfProcessChart(row.orderId);
      }
    },
    {
      title: '参与人',
      field: 'assignNames',
      width: 150,
      renderCustom: ({row})=>{
        if(!row.assignNames){
          return '';
        }
        return `${row.assignNames}(${row.assignCode_alias})`
      }
    },
    {
      title: '任务ID',
      field: 'id',
      width: 180,
      visible: false,
      resizable: true
    },
    {
      title: '流程实例ID',
      field: 'orderId',
      width: 180,
      query: true,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '任务名称',
      field: 'name',
      width: 180,
      query: true,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '任务标题',
      field: 'taskTitle',
      width: 150,
      query: true,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '参与类型',
      field: 'performType_alias',
      width: 100,
    },
    {
      title: '任务类型',
      field: 'taskType_alias',
      width: 100,
      renderCustom: ({row}) => {
        return h(ElTag,{type: calcTagType(row.taskType)}, {
          default: () => row.taskType_alias
        })
      }
    },
    {
      title: '审批结果',
      field: 'approveResult',
      width: 100,
      renderCustom: ({row}) => {
        if('MAJOR' === row.taskType){
          if (!XEUtils.isUndefined(row.approveStrategy)) {
            // @ts-ignore
            return h(ElTag,{type: (1 === row.approveResult? 'primary': 'danger')}, {
              default: () => 1 === row.approveResult? '同意': '不同意'
            })
          }
        }
        return '';
      }
    },
    {
      title: '审批策略',
      field: 'approveStrategy',
      width: 100,
    },
    {
      title: '审批意见',
      field: 'approveRemake',
      width: 100,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '创建时间',
      field: 'createTime',
      width: 170,
      sortable: true,
    },
    {
      title: '完成时间',
      field: 'finishTime',
      width: 170,
      sortable: true,
    }
  ];
}

function calcTagType(type) {
  if (type === 'MESSAGE') {
    return 'info'
  }
  if (type === 'USER') {
    return 'success'
  }
}

export const OpTypeEnum = {
  TASK_TRANSFER: {
    value: 'taskTransfer',
  },
  RELOAD_TASK_ASSIGN: {
    value: 'reloadTaskAssign',
  },
  JUMP_TASK: {
    value: 'jumpTask',
  }
};

export const formSchema: FormSchema[] = [
  {
    field: 'taskId',
    title: '任务ID',
    component: 'Input',
    show: false,
  },
  {
    field: 'orderId',
    title: '实例ID',
    component: 'Input',
    show: false,
  },
  {
    field: 'opType',
    title: '操作类型',
    component: 'Input',
    show: false,
  },
  {
    field: 'userIds',
    title: '指定人',
    required: true,
    component: 'BindEntity',
    show: ({model}) => model.opType === OpTypeEnum.RELOAD_TASK_ASSIGN.value,
    componentProps: {
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      queryFields: "name,code",
      fields: "id,code,name",
      serviceName: 'link-system-start',
      multiple: true
    }
  },
  {
    field: 'jumpNodeKey',
    title: '跳转节点',
    required: true,
    component: 'Select',
    show: ({model}) => model.opType === OpTypeEnum.JUMP_TASK.value,
    componentProps({formModel}){
      return {
        filterable: true,
        options: formModel.allNodes || [],
        props: {
          label: 'name',
          value: 'key'
        }
      }
    }
  },
  {
    field: 'taskTransferUserId',
    title: '转交人',
    required: true,
    component: 'BindEntity',
    show: ({model}) => model.opType === OpTypeEnum.TASK_TRANSFER.value,
    componentProps: {
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      queryFields: "name,code",
      fields: "id,code,name",
      serviceName: 'link-system-start',
      multiple: false
    }
  },
  {
    field: 'taskTransferRemake',
    title: '转交意见',
    required: true,
    component: 'Input',
    show: ({model}) => model.opType === OpTypeEnum.TASK_TRANSFER.value,
    componentProps: {
      type: 'textarea'
    }
  },
];
