import Cookies, {CookieAttributes} from "js-cookie";

export const Local = {
	// 设置永久缓存
	set(key: string, val: any) {
		window.localStorage.setItem(key, JSON.stringify(val));
	},
	// 获取永久缓存
	get(key: string) {
		let json: any = window.localStorage.getItem(key);
    if (json) {
      return JSON.parse(json);
    }
	},
	// 移除永久缓存
	remove(key: string) {
		window.localStorage.removeItem(key);
	},
	// 移除全部永久缓存
	clear() {
		window.localStorage.clear();
	},
};

export const Cookie = {
  set(key: string, val: any, options?: CookieAttributes) {
    Cookies.set(key, JSON.stringify(val), options);
  },
  get(key: string) {
    let json: any = Cookies.get(key);
    if (json) {
      return JSON.parse(json);
    }
  },
  remove(key: string) {
    Cookies.remove(key);
  }
};

export const Session = {
	// 设置临时缓存
	set(key: string, val: any) {
		window.sessionStorage.setItem(key, JSON.stringify(val));
	},
	// 获取临时缓存
	get(key: string) {
		let json: any = window.sessionStorage.getItem(key);
		if (json) {
      return JSON.parse(json);
    }
	},
	// 移除临时缓存
	remove(key: string) {
		window.sessionStorage.removeItem(key);
	},
	// 移除全部临时缓存
	clear() {
		window.sessionStorage.clear();
	},
};
