import {createRouter, createWebHashHistory, RouteRecordRaw} from 'vue-router';
import NProgress from 'nprogress';
import 'nprogress/nprogress.css';
import {store} from '@/store/index';
import {getToken, setToken} from '@/utils/auth';
import {NextLoading} from '@/plugins/loading';
import {staticRoutes} from '@/router/route';

const router = createRouter({
	history: createWebHashHistory(), //createWebHistory
	routes: staticRoutes,
  strict: true,
  scrollBehavior: () => ({ left: 0, top: 0 })
});
// 路由加载前
router.beforeEach( (to, _from, next) => {
	NProgress.configure({ showSpinner: false });
	if (to.meta.title) NProgress.start();
  let token = to.query['token'] as string;
  if (!token) {
    token = getToken();
  } else {
    setToken(token)
  }
	if (to.path === '/login' && !token) {
		next();
		NProgress.done();
	} else {
		if (!token) {
			next(`/login?redirect=${to.path}&params=${JSON.stringify(to.query ? to.query : to.params)}`);
			NProgress.done();
		} else if (token && to.path === '/login') {
			next('/home');
			NProgress.done();
		} else {
			if (!store.state.permission.isLoadMenus) {
			  store.dispatch('permission/generateRoutes').then(async (accessRoutes: RouteRecordRaw[]) => {
          // 防止异步延迟重复生成路由
          if (!store.getters.loadMenus) {
            accessRoutes.forEach(rou => {
              try {
                if (!router.hasRoute(rou.name as string)) router.addRoute(rou);
              } catch (e) {
                console.error('路由配置不合法！', rou.name)
              }
            });
            await store.dispatch('permission/setLoadMenus', true);
            next({ ...to, replace: true }) // hack方法 确保addRoutes已完成
          }
        })
			} else {
				next();
			}
		}
	}
});

// 路由加载后
router.afterEach(() => {
	NProgress.done();
	NextLoading.done();
});

// 导出路由
export default router;


export const resetRouter = (): void => {
  const resetWhiteNameList = ['AnyMatch'].concat(staticRoutes.map(i => i.name as string));
  router.getRoutes().forEach((route) => {
    const { name } = route;
    if (name && !resetWhiteNameList.includes(name as string)) {
      router.hasRoute(name) && router.removeRoute(name)
    }
  })
};
