import request from '@/utils/request';

enum Api {
  listUrl = '/file/SysFiles/list',
  saveUrl = '/file/SysFiles/save',
  deleteUrl = '/file/SysFiles/deleteFile/',
  viewUrl = '/file/SysFiles/view/',
  changeEnableUrl = '/file/SysFiles/changeEnable',
  getFileListUrl = '/file/SysFiles/getFileList',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

export function getFileList(data: {billId: string, type: string}) {
  return request({
    url: Api.getFileListUrl + `/${data.billId || ''}/${data.type || 'MAIN'}`,
    method: 'GET',
  });
}

