import { defineConfig } from 'vite';
import vue from '@vitejs/plugin-vue';
import { resolve } from 'path';
import svgLoader from './src/plugins/svgicon/loader'
import vueJsx from '@vitejs/plugin-vue-jsx';

const pathResolve = (dir: string): any => {
	return resolve(__dirname, '.', dir);
};


const alias: Record<string, string> = {
	'@': pathResolve('./src'),
};

export default defineConfig(({mode}) => ({
  plugins: [
    vue(),
    vueJsx(),
    svgLoader('./src/assets/svg/')
  ],
  root: process.cwd(),
  resolve: { alias },
  base: mode === 'development' ? '/': './',
  server: {
    host: '0.0.0.0',
    port: 3010,
    open: false
  },
  build: {
    outDir: 'dist',
    minify: 'esbuild',
    sourcemap: false,
    chunkSizeWarningLimit: 1500,
    assetsDir: 'webresource',
    rollupOptions: {
      output: {
        entryFileNames: `webresource/app/[name]-[hash].js`,
        chunkFileNames: `webresource/js/[name].${new Date().getTime()}.js`,
        manualChunks(id) {
          if (id.includes('node_modules')) {
            const arr = id.toString().split('node_modules/')[1].split('/');
            switch(arr[0]) {
              case 'link-components':
              case 'monaco-editor':
              case 'vxe-table':
              case 'vxe-utils':
              case '@vue':
              case 'element-plus': // UI 库
              case '@element-plus': // 图标
                return '_' + arr[0];
              default :
                return '__vendor';
            }
          }
        }
      },
    },
  },
  css: {
    postcss: {
      plugins: [
        {
          postcssPlugin: 'internal:charset-removal',
          AtRule: {
            charset: (atRule) => {
              if (atRule.name === 'charset') {
                atRule.remove();
              }
            },
          },
        },
      ],
    },
  },
}))
