import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle } from '@/views/common/utils';

export function listColumns(showDetail: Function, _handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60, fixed: 'left',},
    {
      title: '日志标题',
      field: 'title',
      width: 200,
      query: {
        component: 'Input',
        colProps: 5,
      },
      fixed: 'left',
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'title');
      }
    },
    {
      title: '日志类型',
      field: 'types',
      sortable: true,
      query: {
        component: 'RadioGroup',
        colProps: 8,
        componentProps:{
          options: [
            {label: '全部'},
            {label: '接口', value: 'ITF'},
            {label: '登陆', value: 'LOGIN'},
            {label: '访问', value: 'REQ'},
          ]
        }
      },
      width: 100,
      renderCustom: ({ row }) => {
        return 'LOGIN' === row.types? '登陆日志': 'ITF' === row.types? '接口日志': '访问日志';
      }
    },
    {
      title: '状态',
      field: 'status',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return h(ElTag,{type: (1 === row.status?'success':'danger')},1 === row.status?'成功':'失败');
      }
    },
    {
      title: '操作人',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      query: {
        component: 'Input',
        colProps: 5,
      },
      width: 100,
    },
    {
      title: '请求方式',
      field: 'methods',
      width: 100,
      renderCustom: ({ row }) => {
        return h(ElTag,{},row.methods);
      }
    },
    {
      title: '执行时间',
      field: 'times',
      sortable: true,
      width: 120,
      align: 'right',
      titleHelp: {content: '单位为毫秒(ms)'},
    },
    {
      title: '请求IP',
      field: 'remoteAddr',
      width: 150,
    },
    {
      title: '请求地址',
      field: 'requestUri',
      width: 150,
    },
    {
      title: '请求时间',
      field: 'lastUpdateTime',
      sortable: true,
      query: {
        queryType: 'BETWEEN',
        component: 'DatePicker',
        componentProps:{
          type: 'daterange',
          valueFormat: 'YYYY-MM-DD'
        },
      },
      width: 170,
    },
    {
      title: '用户代理',
      field: 'userAgent',
      width: 200,
      showOverflow: "ellipsis"
    },
    {
      title: '请求参数',
      field: 'params',
      width: 200,
      showOverflow: "ellipsis"
    },
    {
      title: '错误信息',
      field: 'exceptions',
      showOverflow: "ellipsis",
      width: 200,
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'status',
    title: '状态',
    component: 'RadioButtonGroup',
    formatter: ({model}) =>{
      return h(ElTag,{type: (1 === model.status?'success':'danger')},1 === model.status?'成功':'失败');
    }
  },
  {
    field: 'types',
    title: '日志类型',
    component: 'Input',
    formatter: ({model})=>{
      return 'LOGIN' === model.types? '登陆日志': 'ITF' === model.types? '接口日志': '访问日志';
    }
  },
  {
    field: 'title',
    title: '日志标题',
    component: 'Input',
  },
  {
    field: 'remoteAddr',
    title: '请求地址',
    component: 'Input',
  },
  {
    field: 'userAgent',
    title: '用户代理',
    component: 'Input',
  },
  {
    field: 'requestUri',
    title: '请求方法',
    component: 'Input',
  },
  {
    field: 'methods',
    title: '请求方式',
    component: 'Input',
  },
  {
    field: 'times',
    title: '执行时间',
    component: 'InputNumber',
  },
  {
    field: 'exceptions',
    title: '错误信息',
    component: 'Input',
  },
  {
    field: 'params',
    title: '请求参数',
    component: 'Input',
  },
];

