import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '用户编号',
      field: 'code',
      query: {
        colProps: 5,
        component: 'Input',
      },
      sortable: true,
      width: 120,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '用户实名',
      field: 'name',
      query: {
        colProps: 5,
        component: 'Input',
      },
      sortable: true,
      width: 100,
    },
    {
      title: '头像',
      field: 'photo',
      width: 50,
      renderCustom: ({row})=>{
        return h('img',{src: row.photo, width: 30});
      }
    },
    {
      title: '状态',
      field: 'isEnable',
      query: {
        colProps: 8,
        component: 'RadioGroup',
        componentProps: {
          options: [{
            label: '全部',
          },{
            label: '启用',
            value: 1
          },{
            label: '禁用',
            value: 0
          }]
        }
      },
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '关联人员',
      field: 'personId_alias',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '邮箱',
      field: 'email',
      sortable: true,
      width: 160,
      align: 'left',
    },
    {
      title: '排序号',
      field: 'seq',
      width: 80,
      align: 'right',
    },
    {
      title: '手机号',
      field: 'phone',
      sortable: true,
      width: 140,
      align: 'left',
    },
    {
      title: '账号来源',
      field: 'sources',
      sortable: true,
      align: 'left',
      width: 100,
      renderCustom: ({row}) =>{
        return h(ElTag,{},row.sources === 'SYS'? '系统预设': row.sources === 'INPUT'? '手工新建': row.sources)
      }
    },
  ];
}

export const formSchemaExt: FormSchema[] = [
  {
    field: 'extA',
    title: '扩展信息1',
    component: 'Input',
  },
  {
    field: 'extB',
    title: '扩展信息2',
    component: 'Input',
  },
  {
    field: 'extC',
    title: '扩展信息3',
    component: 'Input',
  },
  {
    field: 'extD',
    title: '扩展信息4',
    component: 'Input',
  },
  {
    field: 'extE',
    title: '扩展信息5',
    component: 'Input',
  },
]
export function formSchema(_getOrgTreeData: any): FormSchema[] {
  return [
    {
      field: 'id',
      title: 'id',
      component: 'Input',
      show: false,
    },
    {
      field: 'salt',
      title: '盐',
      component: 'Input',
      show: false,
    },
    {
      field: 'password',
      title: '密码',
      component: 'Input',
      show: false,
    },
    {
      field: 'sources',
      title: '账号来源',
      required: true,
      colProps: 24,
      component: 'Input',
      defaultValue: 'SYS',
      slot: 'sources'
    },
    {
      field: 'personId',
      title: '关联人员',
      component: 'BindEntity',
      componentProps: () =>({
        billVo: 'com.link.jiandanbiao.sys.vo.PersonVo',
        fields: 'code,name,phone,email',
        dynFilter: 'is_enable =1',
        serviceName: 'link-system-start',
        queryFields: 'name,code',
        props: {
          label: 'name',
          value: 'id'
        }
      })
    },
    {
      field: 'photo',
      title: '用户头像',
      colProps: 12,
      helpMessage: '点击头像可以上传新的头像',
      component: 'Input',
      slot: 'photo'
    },
    {
      field: 'code',
      title: '用户编码',
      required: false,
      placeholder: '保存自动生成',
      component: 'Input',
    },
    {
      field: 'name',
      title: '用户实名',
      required: true,
      component: 'Input',
    },
    {
      field: 'email',
      title: '邮箱',
      component: 'Input',
    },
    {
      field: 'isEnable',
      title: '状态',
      required: true,
      component: 'RadioGroup',
      defaultValue: 1,
      componentProps: {
        options: [
          { label: '启用', value: 1 },
          { label: '禁用', value: 0 },
        ],
      },
    },
    {
      field: 'phone',
      title: '手机号',
      component: 'Input',
    },
    {
      field: 'openId',
      title: 'openId',
      component: 'Input',
    },
    {
      field: 'seq',
      title: '排序号',
      component: 'InputNumber',
    },
    {
      field: 'remake',
      title: '备注',
      colProps: 24,
      component: 'Input',
      componentProps: {
        type: 'textarea',
        showWordLimit: true,
      }
    },
  ];
}
