import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag, ElMessage } from 'element-plus'
import XEUtils from "xe-utils";
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '人员编号',
      field: 'code',
      width: 100,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '人员名称',
      field: 'name',
      sortable: true,
      query: true,
      width: 100,
      align: 'left',
    },
    {
      title: '邮箱',
      field: 'email',
      sortable: true,
      query: true,
      width: 100,
      align: 'left',
    },
    {
      title: '手机号',
      field: 'phone',
      sortable: true,
      query: true,
      width: 100,
      align: 'left',
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 110,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      field: 'positionId_alias',
      title: '所属职位',
      width: 130,
    },
    {
      field: 'orgId_alias',
      title: '所属组织',
      width: 130,
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 168,
      align: 'left',
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
  ];
}

export const formSchemaExt: FormSchema[] = [
  {
    field: 'extA',
    title: '扩展信息1',
    component: 'Input',
  },
  {
    field: 'extB',
    title: '扩展信息2',
    component: 'Input',
  },
  {
    field: 'extC',
    title: '扩展信息3',
    component: 'Input',
  },
  {
    field: 'extD',
    title: '扩展信息4',
    component: 'Input',
  },
  {
    field: 'extE',
    title: '扩展信息5',
    component: 'Input',
  },
  {
    field: 'extF',
    title: '扩展信息6',
    component: 'Input',
  },
  {
    field: 'extG',
    title: '扩展信息7',
    component: 'Input',
  },
]

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '编码',
    required: false,
    placeholder: '保存自动生成',
    component: 'Input',
  },
  {
    field: 'name',
    title: '名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'email',
    title: '邮箱',
    component: 'Input',
  },
  {
    field: 'phone',
    title: '手机号',
    component: 'Input',
  },
  {
    field: 'orderNumber',
    title: '排序号',
    component: 'Input',
  },
  {
    field: 'isEnable',
    title: '状态',
    component: 'RadioGroup',
    required: true,
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
  {
    field: 'remake',
    title: '备注',
    component: 'Input',
    colProps: 24,
    componentProps:{
      type: 'textarea'
    }
  },
];

export function positionTables(getOrgPositionTreeData : any) : TableColumnSchema[] {
  return [
    {
      field: 'effectiveDate',
      title: '生效日期',
      width: 130,
      required: true,
      editRender: {
        component: 'DatePicker',
      }
    },
    {
      field: 'positionId',
      title: '所属职位',
      width: 130,
      required: true,
      editRender: {
        component: 'BindDict',
        componentProps: ({row}) =>{
          return {
            type: 'TreeSelect',
            apiType: 'api',
            api: getOrgPositionTreeData,
            filterable: true,
            props: {
              label: 'name',
              value: 'id',
              disabled: (data: any)=>{
                return 'ORG' === data.type
              },
            },
            onChange: (value: any)=>{
              row.orgId = '';
              row.orgId_alias = '';
              getOrgPositionTreeData().then(res=>{
                const options = res.data;
                let selectItem = XEUtils.findTree<Object,Object>(options, item => item['id'] === value, {children: 'children'}) as any;
                if('ORG' === selectItem.item.type){
                  row.positionId = '';
                  row['positionId_alias'] = '';
                  ElMessage.warning('请选择一个有效的职位信息！');
                  return;
                }
                row['positionId_alias'] = selectItem.item.name;
                do{
                  selectItem = XEUtils.findTree<Object,Object>(options, item => item['id'] === selectItem.item.parentId, {children: 'children'}) as any;
                  if('ORG' === selectItem.item.type){
                    row.orgId_alias =  selectItem.item['name'];
                    row.orgId =  selectItem.item['id'];
                  }
                } while('ORG' !== selectItem.item.type);
              })
            }
          }
        }
      },
      renderCustom: ({row})=>{
        return row['positionId_alias'];
      }
    },
    {
      field: 'orgId',
      title: '所属组织',
      width: 130,
      visible: false,
    },
    {
      field: 'orgId_alias',
      title: '所属组织',
      width: 130,
    },
    {
      field: 'isMainPosition',
      title: '是否主要职位',
      width: 140,
      editRender: {
        component: 'Switch',
        componentProps: {
          activeValue: 1,
          inactiveValue: 0,
        }
      },
      renderCustom: ({row})=>{
        return h(ElTag, { type: 1 === row.isMainPosition?"success":"danger"}, () =>  1 === row.isMainPosition? '主岗': '兼岗');
      },
    },
  ]
}
