import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '编号',
      field: 'code',
      width: 130,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '名称',
      field: 'name',
      width: 150,
      query: true,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '实体路径',
      field: 'path',
      width: 200,
      query: true,
    },
    {
      title: '实体名称',
      field: 'entityName',
      width: 100,
      query: true,
    },
    {
      title: '备注',
      field: 'remake',
      width: 150,
      query: true,
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '编码',
    required: false,
    placeholder: '保存后自动生成',
    component: 'Input',
  },
  {
    field: 'name',
    title: '名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'path',
    required: true,
    title: '实体路径',
    component: 'Input',
  },
  {
    field: 'entityName',
    title: '实体名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'splitSeq',
    title: '分隔符号',
    component: 'RadioGroup',
    required: true,
    componentProps: {
      options: [
        { label: '无', value: 'null' },
        { label: '/', value: '/' },
        { label: '-', value: '-' },
        { label: '*', value: '*' },
        { label: '$', value: '$' },
      ],
    },
  },
  {
    field: 'isEnable',
    title: '状态',
    component: 'RadioGroup',
    required: true,
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },

  {
    field: 'remake',
    title: '备注',
    colProps: 24,
    component: 'Input',
    componentProps: {
      type: 'textarea'
    }
  },
];

export const tableCodeRuleHis: TableColumnSchema[] = [
  {
    field: 'keyGroup',
    title: '规则分组标识',
    width: 130,
  },
  {
    field: 'serial',
    title: '当前顺序号',
    width: 130,
  },
];
export const tableCodeRuleSetting: TableColumnSchema[] = [
  {
    field: 'types',
    title: '类型',
    width: 130,
    required: true,
    editRender: {
      component: 'Select',
      componentProps:{
        options: [
          {label: '顺序号', value: 'SEQ'},
          {label: '系统日期', value: 'DATE'},
          {label: '固定值', value: 'VALUE'}
        ],
        props: {
          label: 'label',
          value: 'value',
        }
      }
    }
  },
  {
    field: 'format',
    title: '格式化',
    width: 200,
    editRender: {
      component: 'Select',
      componentProps:{
        options: [
          {label: 'yyyy-MM-dd', value: 'yyyy-MM-dd'},
          {label: 'yyyyMMdd', value: 'yyyyMMdd'},
          {label: 'yyyy-MM', value: 'yyyy-MM'},
          {label: 'yyyyMM', value: 'yyyyMM'},
          {label: 'yyyy-MM-dd HH:mm:ss', value: 'yyyy-MM-dd HH:mm:ss'},
          {label: 'yyyyMMddHHmmss', value: 'yyyyMMddHHmmss'},
        ],
        props: {
          label: 'label',
          value: 'value',
        }
      }
    }
  },
  {
    field: 'settGroup',
    title: '分类排序',
    width: 130,
    editRender: {
      component: 'Switch',
      componentProps: {
        activeValue: 1,
        inactiveValue: 0,
      }
    },
    renderCustom: ({row})=>{
      return h(ElTag, { type: 1 === row.settGroup?"success":"danger"}, () =>  1 === row.settGroup? '分组': '不分组');
    },
  },
  {
    field: 'seqMax',
    title: '顺序号长度',
    width: 130,
    editRender: {
      component: 'InputNumber',
    }
  },
  {
    field: 'value',
    title: '值',
    width: 130,
    editRender: {
      component: 'Input',
    }
  },
];

