import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle } from '@/views/common/utils';

export function listColumns(showDetail: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '#', width: 20},
    {type: 'radio',title: '选择', width: 60},
    {
      title: '任务名称',
      field: 'name',
      query: true,
      width: 200,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'name');
      }
    },
    {
      title: '状态',
      field: 'isEnable',
      sortable: true,
      width: 70,
      renderCustom: ({ row }) => {
        return h(ElTag,{type: 1 === row.isEnable?'success':'danger'}, 1 === row.isEnable? '运行中': '已暂停');
      }
    },
    {
      title: '类型',
      field: 'types',
      width: 70,
      renderCustom: ({ row }) => {
        return h(ElTag,{}, row.types);
      }
    },
    {
      title: 'cron表达式',
      field: 'cronExpression',
      width: 140,
    },
    {
      title: '执行类',
      field: 'className',
      width: 160,
    },
    {
      title: '执行方法',
      field: 'methodName',
      width: 100,
    },
    {
      title: '执行地址',
      field: 'url',
      width: 160,
    },
    {
      title: '参数',
      field: 'params',
      width: 100,
    },
    {
      title: '备注',
      field: 'remake',
      width: 160,
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'name',
    title: '任务名称',
    required: true,
    component: 'Input',
  },
  {
    field: 'types',
    title: '类型',
    component: 'RadioGroup',
    defaultValue: 'ClASS',
    helpMessage: '当为URL模式时只能为post请求，参数将放在body里',
    componentProps: {
      options: [
        { label: '类路径或BeanName模式', value: 'ClASS' },
        { label: 'URL模式', value: 'URL' },
      ],
    },
  },
  {
    field: 'url',
    title: '执行URL',
    required: true,
    show: ({values})=> 'URL' === values.types,
    component: 'Input',
  },
  {
    field: 'className',
    title: '执行类',
    required: true,
    show: ({values})=> 'ClASS' === values.types,
    component: 'Input',
  },
  {
    field: 'methodName',
    title: '执行方法',
    required: true,
    show: ({values})=> 'ClASS' === values.types,
    component: 'Input',
  },
  {
    field: 'params',
    title: '参数',
    component: 'Input',
  },
  {
    field: 'cronExpression',
    title: 'cron表达式',
    required: true,
    colProps: 12,
    component: 'Input',
  },
  {
    field: 'isEnable',
    title: '状态',
    colProps: 12,
    required: true,
    component: 'RadioGroup',
    defaultValue: 0,
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
  {
    field: 'remake',
    title: '备注',
    component: 'Input',
    componentProps:{
      type: 'textarea'
    }
  },
];

