import { TableColumnSchema, FormSchema } from 'link-components';
import { h } from 'vue';
import { ElTag } from 'element-plus'
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '编号',
      field: 'code',
      width: 100,
      query: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '创建时间',
      width: 160,
      field: 'createTime',
    },
    {
      title: '创建人',
      field: 'createUserId',
      width: 100,
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 160,
      align: 'left',
    },
    {
      title: '最后修改人对应角色名称',
      field: 'roleName_alias',
      sortable: true,
      width: 160,
      align: 'left',
    },
    {
      title: '最后更新人ID',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
    {
      title: '名称',
      field: 'name',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '编码',
      field: 'code',
      sortable: true,
      width: 100,
      align: 'left',
    },
    {
      title: '测试字典',
      field: 'testDict_alias',
      sortable: true,
      width: 100,
    },
    {
      title: '供应商分类',
      field: 'supplierType',
      sortable: true,
      width: 100,
      align: 'left',
    },
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'name',
    title: '名称',
    component: 'Input',
  },
  {
    field: 'code',
    title: '编码',
    component: 'Input',
  },
  {
    field: 'supplierType',
    title: '供应商分类',
    component: 'Input',
  },
  {
    field: 'testDict',
    title: '测试字典',
    component: 'BindDict',
    componentProps: {
      type: 'radio',
      apiType: 'dict',
      dictGroup: 'test',
    }
  },
];


