import { TableColumnSchema, FormSchema } from 'link-components';
import {h} from "vue";
import { ElTag, ElButton } from 'element-plus'
import { viewWfProcessChart, createOpenTitle } from '@/views/common/utils';

export function listColumns(openBill: any, approvePage: any): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 50},
    {
      title: 'assignCode_alias',
      field: 'assignCode_alias', 
      visible: false,
    },
    {
      title: 'taskType',
      field: 'taskType', 
      visible: false,
    },
    {
      title: '操作',
      field: 'opt', 
      width: 80,
      renderCustom: ({row})=>{
        return h(ElButton,{type: 'primary', size: 'small', onClick: ()=>{
          approvePage(row);
        }}, '处理')
      }
    },
    {
      title: '任务标题',
      field: 'taskTitle',
      width: 250,
      query: true,
      showOverflow: 'tooltip',
      resizable: true,
      renderCustom: ({ row }) => {
        return createOpenTitle(openBill,row,'taskTitle');
      }
    },
    {
      title: '任务名称',
      field: 'name',
      width: 180,
      query: true,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '到达时间',
      field: 'createTime',
      width: 170,
      sortable: true,
    },
    {
      title: '流程状态',
      field: 'orderId_alias',
      width: 100,
      sortable: true,
      renderCustom: ({row})=>{
        let stateType = 'primary';
        let alais = '已完成';
        if('Active' === row.orderId_alias){
          stateType = 'primary';
          alais = '运行中';
        }
        if('Cancelled' === row.orderId_alias){
          stateType = 'info';
          alais = '已取消';
        }
        if('Suspended' === row.orderId_alias){
          stateType = 'danger';
          alais = '已挂起';
        }
        if('Stop' === row.orderId_alias){
          stateType = 'warning';
          alais = '已终止';
        }
        
        return h(ElTag,{type: stateType}, {
          default: () => alais
        }) 
      }
    },
    {
      title: '流程结束时间',
      field: 'orderFinishTime_alias',
      width: 170,
      sortable: true,
    },
    {
      title: '参与类型',
      field: 'performType_alias',
      width: 100,
    },
    {
      title: '任务状态',
      field: 'taskState_alias',
      width: 100,
      renderCustom: ({row}) => {
        return row.taskState_alias ? h(ElTag,{type: row.taskState === 'Completed' ? 'success' : (row.taskState === 'Todo'?'primary': 'danger')}, {
          default: () => row.taskState_alias
        }): ''
      }
    },
    {
      title: '流程图',
      field: 'process_view',
      width: 100,
      renderCustom: ({row})=>{
        return viewWfProcessChart(row.orderId);
      }
    },
    {
      title: '参与人',
      field: 'assignNames',
      width: 150,
      renderCustom: ({row})=>{
        if(!row.assignNames){
          return '';
        }
        return `${row.assignNames}(${row.assignCode_alias})`
      }
    },
    {
      title: '任务ID',
      field: 'id',
      width: 180,
      visible: false,
      resizable: true
    },
    {
      title: '流程实例ID',
      field: 'orderId',
      visible: false,
    },
    {
      title: '审批结果',
      field: 'approveResult',
      width: 100,
      renderCustom: ({row}) => {
        if('MAJOR' === row.taskType){
          return h(ElTag,{type: (1 === row.approveResult? 'primary': 'danger')}, {
            default: () => 1 === row.approveResult? '同意': '不同意'
          })
        }
        return '';
      }
    },
    {
      title: '审批策略',
      field: 'approveStrategy',
      width: 100,
    },
    {
      title: '审批意见',
      field: 'approveRemake',
      width: 100,
      showOverflow: 'tooltip',
      resizable: true
    },
    {
      title: '完成时间',
      field: 'finishTime',
      width: 170,
      sortable: true,
    }
  ];
}
