import { TableColumnSchema, FormSchema } from 'link-components';
import {createSwitch } from '@/views/common/utils';

export function listColumns(_showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '委托人',
      field: 'operatorId_alias',
      width: 100,
      query: true,
    },
    {
      title: '受托人',
      field: 'surrogateId_alias',
      width: 100,
      query: true,
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      field: 'surrogateDate',
      title: '委托时间',
      width: 190
    },
    {
      field: 'remark',
      title: '备注',
      resizable: true,
      width: 180
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      width: 120,
      align: 'left',
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 170,
      align: 'left',
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'dataVersion',
    title: 'dataVersion',
    component: 'Input',
    show: false,
  },
  {
    field: 'operatorId',
    title: '委托人',
    component: 'BindEntity',
    required: true,
    componentProps: {
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      fields: 'id,name,code',
      serviceName: 'link-system-start',
      dynFilter: ``,
      multiple: false,
      queryFields: 'name,code',
      props: {
        label: 'name',
        value: 'id'
      },
    }
  },
  {
    field: 'surrogateId',
    title: '受托人',
    required: true,
    component: 'BindEntity',
    componentProps: {
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      fields: 'id,name,code',
      serviceName: 'link-system-start',
      dynFilter: ``,
      multiple: false,
      queryFields: 'name,code',
      props: {
        label: 'name',
        value: 'id'
      },
    }
  },
  {
    field: 'processKeys',
    title: '委托流程',
    component: 'BindDict',
    colProps: 24,
    componentProps: {
      type: 'Select',
      filterable: true,
      clearable: true,
      multiple: true,
      billVo: 'com.link.jiandanbiao.bpm.core.vo.WfProcessVo',
      fields: 'name,id,processKey',
      serviceName: 'link-bpm-start',
      dynFilter: 'is_last=1',
      props: {
        label: 'name',
        value: 'processKey'
      }
    }
  },
  {
    field: 'surrogateDate',
    title: '委托时间',
    component: 'DatePicker',
    required: true,
    componentProps: {
      type: 'daterange',
      startPlaceholder: "开始时间",
      endPlaceholder: "截止时间",
      valueFormat: 'YYYY-MM-DD'
    }
  },
  {
    field: 'isEnable',
    title: '是否启用',
    component: 'Switch',
    componentProps: {
      activeValue: 1,
      inactiveValue: 0
    }
  },
  {
    field: 'remark',
    title: '备注',
    component: 'Input',
    colProps: 24,
    componentProps: {
      type: 'textarea'
    }
  },
];


