import {h} from 'vue';
import { TableColumnSchema } from 'link-components';
import {ElTag} from "element-plus";
import {createSwitch } from '@/views/common/utils';

export function listColumns(_showDetail: Function, handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    {
      title: '流程标识',
      field: 'processKey',
      sortable: true,
      width: 180,
      resizable: true,
      showOverflow: 'tooltip',
      align: 'left',
    },
    {
      title: '流程名称',
      field: 'name',
      width: 150,
      sortable: true,
      resizable: true,
      showOverflow: 'tooltip',
      query: true,
    },
    {
      title: '版本',
      field: 'version',
      width: 70,
      sortable: true,
    },
    {
      title: '是否最新版',
      field: 'isLast',
      width: 100,
      align: 'center',
      renderCustom: ({row}) => {
        return h(ElTag,{type: row.isLast === 1 ? 'success' : 'info'}, row.isLast === 1 ? '是' : '否')
      }
    },
    {
      title: '是否启用',
      field: 'isEnable',
      sortable: true,
      width: 100,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '流程类别',
      field: 'typeId_alias',
      sortable: true,
      width: 160,
      align: 'left',
      query: true,
    },
    {
      title: '流程模式',
      field: 'processMode_alias',
      sortable: true,
      width: 120,
      align: 'left',
      renderCustom: ({row}) => {
        return h(ElTag,{type: row.processMode === 'freeProcess' ? 'warning' : ''}, row.processMode_alias)
      }
    },
    {
      title: '绑定Form',
      field: 'formId',
      resizable: true,
      showOverflow: 'tooltip',
      width: 160,
      align: 'left',
      query: true,
    },
    {
      title: '最后更新时间',
      field: 'lastUpdateTime',
      sortable: true,
      width: 170,
      align: 'left',
    },
    {
      title: '最后更新人',
      field: 'lastUpdateUserId_alias',
      sortable: true,
      width: 120,
      align: 'left',
    },
  ];
}


