import type {RouteRecordRaw} from 'vue-router'

// 布局配置
export interface IThemeConfig {
  isDrawer: boolean;
  primary: string;
  success: string;
  info: string;
  warning: string;
  danger: string;
  topBar: string;
  menuBar: string;
  columnsMenuBar: string;
  topBarColor: string;
  menuBarColor: string;
  columnsMenuBarColor: string;
  activeMenuBar: string;
  activeMenuBarColor: string;
  isTopBarColorGradual: boolean;
  isMenuBarColorGradual: boolean;
  isColumnsMenuBarColorGradual: boolean;
  isMenuBarColorHighlight: boolean;
  isUniqueOpened: boolean;
  isFixedHeader: boolean;
  isFixedHeaderChange: boolean;
  isClassicSplitMenu: boolean;
  isShowLogo: boolean;
  isShowLogoChange: boolean;
  isBreadcrumb: boolean;
  isTagsview: boolean;
  isTagsviewIcon: boolean;
  isCacheTagsView: boolean;
  isSortableTagsView: boolean;
  isGrayscale: boolean;
  isInvert: boolean;
  isIsDark: boolean;
  isWartermark: boolean;
  wartermarkText: string;
  tagsStyle: "tags-style-one" | "tags-style-two" | "tags-style-three" | "tags-style-four" | "tags-style-five";
  animation: "slide-right" | "slide-left" | "opacitys";
  columnsAsideStyle: string | "columns-round" | "columns-card";
  columnsAsideLayout: "columns-horizontal" | "columns-vertical";
  layout: string | "defaults" |" classic" | "transverse" | "columns";
  isRequestRoutes: boolean;
  globalTitle: string;
  globalViceTitle: string;
  globalComponentSize: "small" | "default" | "large"| "";
}

export interface ThemeConfigState {
  themeConfig: IThemeConfig
}

export interface AppState {
  collapse: boolean;
  // 一级导航菜单
  navRoutes: Array<RouteRecordRaw>;
  // 子菜单
  menuRoutes: Array<RouteRecordRaw>;
}

export interface PermissionState {
  isLoadMenus: boolean,
  routes: Array<RouteRecordRaw>,
  addRoutes: Array<RouteRecordRaw>,
  permission: string[]
}

// TagsView 路由列表
export interface TagsViewState {
  visitedViews: Array<RouteRecordRaw>,
  cachedViews: string[],
  currentView: RouteRecordRaw | any,
	isCurrentViewFull: Boolean;
}

// 用户信息
export interface UserState {
  token: string
  userInfo: Object;
}

// 主接口(顶级类型声明)
export interface RootStateTypes {
	themeConfig: ThemeConfigState;
	app: AppState,
  permission: PermissionState;
	tagsView: TagsViewState;
	user: UserState;
}
