import {Module} from 'vuex';
import {RootStateTypes, PermissionState} from '@/store/types';
import {staticRoutes, pathMatch, } from "@/router/route";
import type {RouteRecordRaw} from "vue-router";
import {store} from "@/store";
import { toRouterBase } from "@/router/routerHelper";
import { getDynamicRoutes } from '@/api/login';
import { getCacheUserInfo } from '@/utils/auth';

const permissionModule: Module<PermissionState, RootStateTypes> = {
  namespaced: true,
  state: {
    isLoadMenus: false,
    routes: staticRoutes,
    addRoutes: [],
    permission: getCacheUserInfo().premList || []
  },
  mutations: {
    SET_ROUTES: (state, routes) => {
      state.addRoutes = routes;
      state.routes = staticRoutes.concat(routes)
    },
    SET_PERMISSION: (state, permission) => {
      state.permission = permission
    },
    SET_LOAD_MENUS: (state, isLoadMenus) => {
      state.isLoadMenus = isLoadMenus
    },
  },
  actions: {
    setLoadMenus({ commit }, load: boolean) {
      commit('SET_LOAD_MENUS', load)
    },
    setPermission({ commit }, permission: string[]) {
      commit('SET_PERMISSION', permission)
    },
    async generateRoutes({ commit }) {
      const dynamicRoutes = toRouterBase((await getDynamicRoutes()).data);
      const idx = dynamicRoutes.findIndex(i => i.path === '/');
      // 没有首页自动重定向到第一个有权限的菜单
      if (dynamicRoutes.length && idx === -1) {
        dynamicRoutes.push({
          path: '/',
          redirect: dynamicRoutes[0].path,
          name: 'AutoMatch',
          meta: {
            isHide: true
          }
        })
      }
      return new Promise(resolve => {
        let accessedRoutes: Array<RouteRecordRaw> = [];
        commit('SET_ROUTES', dynamicRoutes);
        accessedRoutes = accessedRoutes.concat(dynamicRoutes, pathMatch);
        store.dispatch('app/setNavRoutes', accessedRoutes);
        commit('SET_PERMISSION', getCacheUserInfo().premList || []);
        resolve(accessedRoutes)
      })
    }
  },
};

export default permissionModule;
