import type { RouteRecordRaw } from 'vue-router';

/**
 * 路由meta对象参数说明
 * meta: {
 *      title:          菜单栏及 tagsView 栏、菜单搜索名称（国际化）
 *      isLink：        是否超链接菜单，开启外链条件，`1、isLink:true 2、链接地址不为空`
 *      isHide：        是否隐藏此路由
 *      isKeepAlive：   是否缓存组件状态
 *      isAffix：       是否固定在 tagsView 栏上
 *      isIframe：      是否内嵌窗口，，开启条件，`1、isIframe:true 2、链接地址不为空`
 *      icon：          菜单、tagsView 图标，阿里：加 `iconfont xxx`，fontawesome：加 `fa xxx`
 * }
 */

export const dynamicRoutes: Array<RouteRecordRaw> = [
	// {
	// 	path: '/',
	// 	component: () => import('@/layout/index.vue'),
	// 	redirect: '/home',
	// 	meta: {
  //     title: '首页',
  //     isHide: false,
  //     isKeepAlive: true,
  //     isAffix: true,
  //     isIframe: false,
  //     icon: 'iconfont icon-shouye',
	// 	},
	// 	children: [
	// 		{
	// 			path: '/home',
	// 			name: 'home',
	// 			component: () => import('@/views/home/index.vue'),
	// 			meta: {
	// 				title: '首页',
	// 				isHide: false,
	// 				isKeepAlive: true,
	// 				isAffix: true,
	// 				isIframe: false,
	// 				icon: 'iconfont icon-shouye',
	// 			},
	// 		},
	// 	],
	// },
	// {
  //   path: '/system',
  //   name: 'system',
	// 	component: () => import('@/layout/index.vue'),
  //   redirect: '/system/role',
  //   meta: {
  //     title: '系统设置',
  //     isHide: false,
  //     isKeepAlive: true,
  //     isAffix: false,
  //     isIframe: false,
  //     roles: ['admin'],
  //     icon: 'iconfont icon-xitongshezhi',
  //   },
  //   children: [
  //     {
  //       path: 'role',
  //       name: 'systemRole',
  //       component: () => import('@/views/system/role/index.vue'),
  //       meta: {
  //         title: '角色管理',
  //         isHide: false,
  //         isKeepAlive: true,
  //         isAffix: false,
  //         isIframe: false,
  //         roles: ['admin'],
  //         icon: 'elementColdDrink',
  //       },
  //     },
  //     {
  //       path: 'user',
  //       name: 'systemUser',
  //       component: () => import('@/views/system/user/index.vue'),
  //       meta: {
  //         title: '用户管理',
  //         isHide: false,
  //         isKeepAlive: true,
  //         isAffix: false,
  //         isIframe: false,
  //         roles: ['admin'],
  //         icon: 'iconfont icon-icon-',
  //       },
  //     },
  //     {
  //       path: 'dept',
  //       name: 'systemDept',
  //       component: () => import('@/views/system/dept/index.vue'),
  //       meta: {
  //         title: '部门管理',
  //         isHide: false,
  //         isKeepAlive: true,
  //         isAffix: false,
  //         isIframe: false,
  //         roles: ['admin'],
  //         icon: 'elementOfficeBuilding',
  //       },
  //     },
  //     {
  //       path: 'dic',
  //       name: 'systemDic',
  //       component: () => import('@/views/system/dic/index.vue'),
  //       meta: {
  //         title: '字典管理',
  //         isHide: false,
  //         isKeepAlive: true,
  //         isAffix: false,
  //         isIframe: false,
  //         roles: ['admin'],
  //         icon: 'elementSetUp',
  //       },
  //     },
  //     {
  //       path: 'person',
  //       name: 'sysPerson',
  //       component: () => import('@/views/sys/Menu/index.vue'),
  //       meta: {
  //         title: '人员信息',
  //         isHide: false,
  //         isKeepAlive: true,
  //         isAffix: false,
  //         isIframe: false,
  //         //roles: ['admin'],
  //         icon: 'elementSetUp',
  //       },
  //     },
  //   ],
	// },
];

export const pathMatch: RouteRecordRaw = {
  path: '/:path(.*)*',
  redirect: '/404',
  meta: {
    isHide: true
  }
};


/**
 * 定义静态路由
 * @description 前端控制直接改 dynamicRoutes 中的路由，后端控制不需要修改，请求接口路由数据时，会覆盖 dynamicRoutes 第一个顶级 children 的内容（全屏，不包含 layout 中的路由出口）
 * @returns 返回路由菜单数据
 */
export const staticRoutes: Array<RouteRecordRaw> = [
  {
    path: '/redirect',
    component: () => import('@/layout/index.vue'),
    name: 'Redirect',
    children: [
      {
        path: '/redirect/:path(.*)',
        name: 'Redirect',
        component: () => import('@/views/redirect/index.vue'),
        meta: {
          isHide: true
        },
      }
    ],
    meta: {
      isHide: true,
      noTagsView: true
    },
  },
	{
		path: '/login',
		name: 'login',
		component: () => import('@/views/login/index.vue'),
		meta: {
			title: '登录',
      isHide: true,
      noTagsView: true
		},
	},
	{
		path: '/404',
		name: 'notFound',
		component: () => import('@/views/error/404.vue'),
		meta: {
			title: '页面找不到',
      isHide: true,
      noTagsView: true
		},
	},
	{
		path: '/401',
		name: 'noPower',
		component: () => import('@/views/error/401.vue'),
		meta: {
			title: '页面无权限',
      isHide: true,
      noTagsView: true
		},
	},
];
