import {computed} from 'vue';
import {store} from '@/store';


/**
 * 用户权限
 */
export function usePermission () {
  const userPermission = computed(() => {
    return store.state.permission.permission || []
  });
  function hasPermissionAll(permission: string[]) {
    return permission.every((v: string) => {
      return userPermission.value.some((val: string) => val === v);
    })
  }

  function hasPermission(permission: string[]) {
    return permission.some((v: string) => {
      return userPermission.value.some((val: string) => val === v);
    })
  }
  return {
    hasPermission,
    hasPermissionAll
  }
}
