import {BindEntityProps} from "@/components/BindEntity/types";
import {serviceNameConst} from "@/config/constant";

export const SystemService = {
  bindOrgProps: function (op?: BindEntityProps| Record<string, any>) {
    return Object.assign({
      serviceName: serviceNameConst.systemService,
      type: 'tree',
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkOrgInfo',
      fields: 'id,name,code,parentId',
      dynFilter: ``,
      multiple: false,
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: [
        {
          title: 'id',
          field: 'id',
          hide: true,
        },
        {
          title: 'parentId',
          field: 'parentId',
          hide: true,
        }
      ]
    },op) as BindEntityProps
  },
  bindUserProps: function (op?: BindEntityProps | Record<string, any>) {
    return Object.assign({
      serviceName: serviceNameConst.systemService,
      billVo: 'com.link.jiandanbiao.sys.api.entity.LinkUserInfo',
      fields: 'id,name,code,phone,email',
      dynFilter: ``,
      multiple: false,
      queryFields: 'name,code',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: [
        {
          title: 'id',
          field: 'id',
          hide: true,
        }
      ],
      key: 'system-service-user'
    },op) as BindEntityProps
  }
};

export const BasicService = {

};
