import type {PropType} from 'vue';
import type {OrderCfg} from "./types";
import {DataBoxDefines} from "link-components";


export const basicProps = {
  billVo: String,
  serviceName: String,
  dynFilter: String,
  fields: {
    type: String,
    default: 'id,name'
  },
  // 需要生成查询的字段
  queryFields: String,
  orderCfgDto: Object as PropType<OrderCfg>,
  props: {
    type: Object as PropType<DataBoxDefines.Props>,
    default: () => ({
      label: "name",
      value: "id",
    })
  },
  // 自动翻译转换别名
  autoConvertAlias: {
    type: Boolean,
    default: true
  },
  // 表格行数据
  tableRow: {
    type: Object
  },
  labelField: {
    type: String,
    default: ''
  }
};
