import request from '@/utils/request';

enum Api {
  listUrl = '/sys/log/list',
  saveUrl = '/sys/log/save',
  deleteUrl = '/sys/log/delete/',
  viewUrl = '/sys/log/view/',
  changeEnableUrl = '/sys/log/changeEnable',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

