import request from '@/utils/request';

enum Api {
  getEntityListData = '/dynamicApi/getEntityListData',
  getEntityModel = '/dynamicApi/getEntityModel',
  getSelectListData = '/dynamicApi/getSelectListData',
  getSelectTreeData = '/dynamicApi/getSelectTreeData',
  getDictTreeData = '/dynamicApi/getDictGroupTree',
  getDictData = '/dynamicApi/getDict',
}


export function getEntityListData(data) {
  return request({
    url: Api.getEntityListData,
    method: 'POST',
    data: data
  });
}


export function getEntityModel(data) {
  return request({
    url: Api.getEntityModel,
    method: 'POST',
    data: data
  });
}

export function getSelectListData(data) {
  return request({
    url: Api.getSelectListData,
    method: 'POST',
    data: data
  });
}

export function getSelectTreeData(data) {
  return request({
    url: Api.getSelectTreeData,
    method: 'POST',
    data: data
  });
}

export function getDictTreeData(data: {dictGroup: string}) {
  return request({
    url: Api.getDictTreeData + `/${data.dictGroup}`,
    method: 'GET'
  });
}

export function getDictData(data: {dictGroup: string}) {
  return request({
    url: Api.getDictData + `/${data.dictGroup}`,
    method: 'GET'
  });
}
