import request from '@/utils/request';
import {guid} from '@/utils/commonFunction'
enum Api {
  listUrl = '/demo/test/list',
  saveUrl = '/demo/test/save',
  deleteUrl = '/demo/test/delete/',
  viewUrl = '/demo/test/view/',
  changeEnableUrl = '/demo/test/changeEnable',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

export function getId() {
  return 'RUKZF' + guid();
}
