import request from '@/utils/request';
import {guid} from '@/utils/commonFunction'
enum Api {
  listUrl = '/demo/Supper/list',
  saveUrl = '/demo/Supper/save',
  deleteUrl = '/demo/Supper/delete/',
  viewUrl = '/demo/Supper/view/',
  changeEnableUrl = '/demo/Supper/changeEnable',
}
export function changeEnable(params) {
  return request({
    url: Api.changeEnableUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteData(id) {
  return request({
    url: Api.deleteUrl + id,
    method: 'DELETE',
  });
}
export function view(id) {
  return request({
    url: Api.viewUrl + id,
    method: 'GET',
  });
}
export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function save(params) {
  return request({
    url: Api.saveUrl,
    method: 'PUT',
    data: params,
  });
}

export function getId() {
  return 'GMQJG' + guid();
}
