import request from '@/utils/request';
import {guid} from '@/utils/commonFunction'
enum Api {
  listUrl = '/bpm/wfOrder/list',
  taskListUrl = '/bpm/wfTask/list',
  taskTransferUrl = '/bpm/approve/taskTransfer',
  jumpTaskUrl = '/bpm/viewApprove/jumpTask',
  reloadTaskAssignUrl = '/bpm/viewApprove/reloadTaskAssign',
  suspendedOrderUrl = '/bpm/viewApprove/suspendedOrder/',
  canCalSuspendedOrderUrl = '/bpm/viewApprove/canCalSuspendedOrder/',
  getProcessAllNodesUrl = '/bpm/viewApprove/getProcessAllNodes/',
  stopOrderUrl = '/bpm/viewApprove/stopOrder/',
  getAllNodeApproveDataUrl = '/bpm/viewApprove/viewAllNodeApproveData/',
  getNodeApproveDataUrl = '/bpm/viewApprove/viewNodeApproveData/',
  viewProcessUrl = '/bpm/viewApprove/viewProcess/',
}

export function getListData(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}

export function getTaskListData(params) {
  return request({
    url: Api.taskListUrl,
    method: 'POST',
    data: params,
  });
}


/**
 *流程转交
 */
export function taskTransfer(data: {taskId: string, taskTransferUserId: string, taskTransferRemake:string}) {
  return request({
    url: Api.taskTransferUrl,
    method: 'POST',
    data: data
  });
}

/**
 *流程跳转
 */
export function jumpTask(data: {orderId: string, jumpNodeKey: string}) {
  return request({
    url: Api.jumpTaskUrl,
    method: 'POST',
    data: data
  });
}

/**
 * 重新指定参与人
 */
export function reloadTaskAssign(data: {taskId: string, userIds: string[]}) {
  return request({
    url: Api.reloadTaskAssignUrl,
    method: 'POST',
    data: data
  });
}

/**
 * 挂起
 */
export function suspendedOrder(orderId) {
  return request({
    url: Api.suspendedOrderUrl + orderId,
    method: 'GET'
  });
}

/**
 * 撤销挂起
 */
export function canCalSuspendedOrder(orderId) {
  return request({
    url: Api.canCalSuspendedOrderUrl + orderId,
    method: 'GET'
  });
}

/**
 * 获取流程实例下所有节点(跳转流程用)
 */
export function getProcessAllNodes(orderId) {
  return request({
    url: Api.getProcessAllNodesUrl + orderId,
    method: 'GET'
  });
}

/**
 * 终止流程
 */
export function stopOrder(orderId) {
  return request({
    url: Api.stopOrderUrl + orderId,
    method: 'GET'
  });
}

/**
 * 获取节点审批数据
 */
export function getNodeApproveData(orderId:string, nodeKey?:string) {
  let url = Api.getAllNodeApproveDataUrl;
  if (nodeKey) {
    url = Api.getNodeApproveDataUrl;
  }
  return request({
    url: url + orderId + (nodeKey ? `/${nodeKey}` : ''),
    method: 'GET'
  });
}

/**
 * 查看流程图
 * @param orderId
 */
export function viewProcess(orderId) {
  return request({
    url: Api.viewProcessUrl + orderId,
    method: 'GET'
  });
}

export function getId() {
  return 'XRUYX' + guid();
}
