import request from '@/utils/request';

enum Api {
  getBillMetadataUrl = '/bpm/wfApprovalSummary/getBillMetadata',
  addFieldItemUrl = '/bpm/wfApprovalSummary/addFieldItem',
  listUrl = '/bpm/wfApprovalSummary/list',
  deleteFieldItemUrl = '/bpm/wfApprovalSummary/deleteFieldItem/',
  saveFieldItemsUrl = '/bpm/wfApprovalSummary/saveFieldItems',
}

export function saveFieldItems(params) {
  return request({
    url: Api.saveFieldItemsUrl,
    method: 'POST',
    data: params,
  });
}
export function deleteFieldItem(entityPath, name) {
  return request({
    url: Api.deleteFieldItemUrl + entityPath + '/' + name,
    method: 'DELETE',
  });
}

export function addFieldItem(params) {
  return request({
    url: Api.addFieldItemUrl,
    method: 'POST',
    data: params,
  });
}
export function list(params) {
  return request({
    url: Api.listUrl,
    method: 'POST',
    data: params,
  });
}
export function getBillMetadata(params) {
  return request({
    url: Api.getBillMetadataUrl,
    method: 'POST',
    data: params,
  });
}
