import { TableColumnSchema, FormSchema } from 'link-components';
import { createOpenTitle, createSwitch } from '@/views/common/utils';

export function listColumns(showDetail: Function,handleChangeStatus: Function): TableColumnSchema[]{
  return [
    {type: 'seq',title: '序号', width: 60},
    // {
    //   title: 'userA_alias',
    //   field: 'userA_alias'
    // },
    // {
    //   title: 'userListObj',
    //   field: 'userListObj.id'
    // },
    {
      title: '角色编码',
      field: 'code',
      query: {
        colProps: 5,
        component: 'Input',
      },
      width: 150,
      renderCustom: ({ row }) => {
        return createOpenTitle(showDetail,row,'code');
      }
    },
    {
      title: '角色名称',
      field: 'name',
      query: {
        colProps: 5,
        component: 'Input',
      },
      sortable: true,
      width: 200,
      align: 'left',
    },
    {
      title: '状态',
      field: 'isEnable',
      query: {
        colProps: 8,
        component: 'RadioGroup',
        componentProps: {
          options: [{
            label: '全部',
          },{
            label: '启用',
            value: 1
          },{
            label: '禁用',
            value: 0
          }]
        }
      },
      width: 90,
      renderCustom: ({ row }) => {
        return createSwitch(handleChangeStatus, row);
      }
    },
    {
      title: '备注',
      field: 'remake',
    }
  ];
}

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'code',
    title: '角色编码',
    component: 'Input',
    required: true,
  },
  {
    field: 'name',
    title: '角色名称',
    component: 'Input',
    required: true,
  },
  {
    field: 'isEnable',
    title: '状态',
    required: true,
    component: 'RadioGroup',
    componentProps: {
      options: [
        { label: '启用', value: 1 },
        { label: '禁用', value: 0 },
      ],
    },
  },
  {
    field: 'remake',
    title: '备注',
    component: 'Input',
    componentProps: {
      type: 'textarea',
    }
  },
  {
    field: 'roleAuthOrity',
    title: '角色权限',
    component: 'Input',
    slot: 'roleAuthOrity'
  }
];

export const roleUserColumns: TableColumnSchema[] = [
  {type: 'seq',title: '序号', width: 60},
  {
    title: '用户编码',
    field: 'userId_code',
    width: 100,
  },
  {
    title: '用户名称',
    field: 'userId_alias',
    width: 100,
  },
]
