import type {FormSchema} from "link-components";

export const formSchema: FormSchema[] = [
  {
    field: 'id',
    title: 'id',
    component: 'Input',
    show: false,
  },
  {
    field: 'radioGroup',
    title: 'RadioGroup',
    component: 'RadioGroup',
    defaultValue: 0,
    componentProps: {
      options: [
        { label: 'A', value: 1 },
        { label: 'B', value: 2 },
        { label: 'C', value: 3 },
        { label: 'D', value: 4 },
      ],
    },
  },
  {
    field: 'checkboxGroup',
    title: 'CheckboxGroup',
    component: 'CheckboxGroup',
    defaultValue: [1],
    componentProps: {
      options: [
        { label: '北京', value: 1 },
        { label: '上海', value: 2 },
        { label: '广州', value: 3 },
        { label: '天津', value: 4 },
        { label: '南昌', value: 5 },
        { label: '武汉', value: 6 },
      ],
    },
  },
  {
    field: 'dictTreeSelect',
    title: 'Dict树型下拉',
    component: 'BindDict',
    componentProps: {
      type: 'TreeSelect',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'dictSelect',
    title: 'Dict下拉',
    component: 'BindDict',
    componentProps: ({formModel}) => {
      return {
        type: 'Select',
        billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
        fields: 'id,name,phone,email',
        dynFilter: formModel.radioGroup == 1 ? `name like '%dst%'`: '',
        props: {
          label: 'name',
          value: 'id',
          formatter: (data) => {
            return `姓名：${data.name || '-'}`
          }
        }
      }
    }
  },
  {
    field: 'dictRadio',
    title: 'DictRadio',
    component: 'BindDict',
    componentProps: {
      type: 'Radio',
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      props: {
        label: 'name',
        value: 'id',
        formatter: (data) => {
          return `姓名：${data.name || '-'}`
        }
      }
    }
  },
  {
    field: 'dictCheckbox',
    title: 'DictCheckbox',
    component: 'BindDict',
    componentProps: {
      type: 'Checkbox',
      boxStyle: 'checkbox',
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      props: {
        label: 'name',
        value: 'id',
        formatter: (data) => {
          return `姓名：${data.name || '-'}`
        }
      }
    }
  },
  {
    field: 'dictCascader',
    title: 'DictCascader',
    component: 'BindDict',
    componentProps: {
      type: 'Cascader',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'user',
    title: '用户DataBox',
    component: 'BindEntity',
    componentProps: ({formModel}) =>({
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      dynFilter: formModel.requestUri === '666' ? `name like '%dst%'`: '',
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: [
        {
          title: '电话号码',
          field: 'email',
          formatter: ({cellValue}) => {
            return `${cellValue || 'x'}@10086.con`
          }
        }
      ]
    })
  },
];

export const dictFormSchema: FormSchema[] = [
  {
    field: 'dictTreeSelect',
    title: 'Dict树型下拉',
    component: 'BindDict',
    componentProps: {
      type: 'TreeSelect',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'dictTreeSelect2',
    title: '树型多选限制',
    component: 'BindDict',
    componentProps: {
      type: 'TreeSelect',
      multiple: true,
      multipleLimit:3,
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'dictSelect',
    title: 'Dict下拉',
    component: 'BindDict',
    componentProps: ({formModel}) => {
      return {
        type: 'Select',
        billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
        fields: 'id,name,phone,email',
        dynFilter: formModel.requestUri === '666' ? `name like '%dst%'`: '',
        props: {
          label: 'name',
          value: 'id',
          formatter: (data) => {
            return `姓名：${data.name || '-'}`
          }
        }
      }
    }
  },
  {
    field: 'dictSelect2',
    title: '下拉多选限制',
    component: 'BindDict',
    componentProps: ({formModel}) => {
      return {
        type: 'Select',
        multiple: true,
        multipleLimit: 3,
        billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
        fields: 'id,name,phone,email',
        dynFilter: formModel.requestUri === '666' ? `name like '%dst%'`: '',
        props: {
          label: 'name',
          value: 'id',
          formatter: (data) => {
            return `姓名：${data.name || '-'}`
          }
        }
      }
    }
  },
  {
    field: 'dictRadio',
    title: 'DictRadio',
    component: 'BindDict',
    componentProps: {
      type: 'Radio',
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      props: {
        label: 'name',
        value: 'id',
        formatter: (data) => {
          return `姓名：${data.name || '-'}`
        }
      }
    }
  },
  {
    field: 'dictCheckbox',
    title: 'DictCheckbox',
    component: 'BindDict',
    componentProps: {
      type: 'Checkbox',
      boxStyle: 'checkbox',
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      props: {
        label: 'name',
        value: 'id',
        formatter: (data) => {
          return `姓名：${data.name || '-'}`
        }
      }
    }
  },
  {
    field: 'dictCascader',
    title: 'DictCascader',
    component: 'BindDict',
    componentProps: {
      type: 'Cascader',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'dictCascader2',
    title: 'Cascader多选',
    component: 'BindDict',
    componentProps: {
      type: 'Cascader',
      billVo: 'com.link.jiandanbiao.sys.vo.MenuVo',
      fields: 'id,title',
      props: {
        label: 'title',
        value: 'id',
        multiple: true,
        formatter: (data) => {
          return `名称：${data.title || '-'}`
        }
      }
    }
  },
  {
    field: 'user',
    title: 'BindEntity',
    component: 'BindEntity',
    colProps: 24,
    componentProps: ({formModel}) =>({
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      dynFilter: formModel.requestUri === '666' ? `name like '%dst%'`: '',
      queryFields: 'name',
      props: {
        label: 'name',
        value: 'id'
      },
      columns: [
        {
          title: '电话号码',
          field: 'email',
          formatter: ({cellValue}) => {
            return `${cellValue || 'x'}@10086.con`
          }
        }
      ]
    })
  },
  {
    field: 'user',
    title: 'databox多选',
    component: 'BindEntity',
    colProps: 24,
    componentProps: ({formModel}) =>({
      billVo: 'com.link.jiandanbiao.sys.vo.UserVo',
      fields: 'id,name,phone,email',
      dynFilter: formModel.requestUri === '666' ? `name like '%dst%'`: '',
      queryFields: 'name',
      multiple: true,
      props: {
        label: 'name',
        value: 'id'
      },
      columns: [
        {
          title: '电话号码',
          field: 'email',
          formatter: ({cellValue}) => {
            return `${cellValue || 'x'}@10086.con`
          }
        }
      ]
    })
  },
];

export const inputFormSchema: FormSchema[] = [
  {
    field: 'input',
    title: 'Input文本框',
    component: 'Input',
  },
  {
    field: 'number',
    title: '数字输入框',
    component: 'Input',
    componentProps: {
      type: 'number',
      placeholder: '限制两位小数',
      precision: 2
    }
  },
  {
    field: 'email',
    title: 'email输入框',
    component: 'Input',
    componentProps: {
      type: 'email'
    }
  },
  {
    field: 'phone',
    title: 'phone输入框',
    component: 'Input',
    componentProps: {
      type: 'phone'
    }
  },
  {
    field: 'password',
    title: '密码框',
    component: 'Input',
    componentProps: {
      type: 'password',
      showPassword: true
    }
  },
  {
    field: 'inputNumber',
    title: 'InputNumber',
    component: 'InputNumber',
    componentProps: {
      precision: 2
    }
  },
  {
    field: 'textarea',
    title: 'textarea',
    component: 'Input',
    colProps: 24,
    componentProps: {
      type: 'textarea',
      maxlength: 500,
      showWordLimit: true,
    }
  }
];



export const elFormSchema: FormSchema[] = [
  {
    field: 'radio',
    title: 'Radio',
    component: 'Radio',
    defaultValue: 0,
    componentProps: {
      label: 1
    },
  },
  {
    field: 'checkbox',
    title: 'Checkbox',
    component: 'Checkbox',
    defaultValue: 0,
    componentProps: {
      trueLabel: 1,
      falseLabel: 0
    }
  },
  {
    field: 'slider',
    title: 'Slider',
    component: 'Slider',
  },
  {
    field: 'switch',
    title: 'Switch',
    component: 'Switch',
    componentProps: {
      activeValue: 1
    },
  },
  {
    field: 'rate',
    title: 'Rate',
    component: 'Rate',
    componentProps: {
      allowHalf: true
    },
  },
  {
    field: 'color',
    title: 'ColorPicker',
    component: 'ColorPicker',
    componentProps: {
      predefine: ['#1890ff', '#13ce66']
    },
  }
];

/**
 * 日期操作
 */
export const elDateFormSchema: FormSchema[] = [
  {
    field: 'year',
    title: 'DatePicker-year',
    component: 'DatePicker',
    componentProps: {
      type: 'year',
      valueFormat: 'YYYY'
    },
  },
  {
    field: 'month',
    title: 'DatePicker-month',
    component: 'DatePicker',
    componentProps: {
      type: 'month',
      valueFormat: 'YYYY-MM'
    },
  },
  {
    field: 'date',
    title: 'DatePicker',
    component: 'DatePicker',
    componentProps: {
      type: 'date',
      valueFormat: 'YYYY-MM-DD'
    },
  },
  {
    field: 'dates',
    title: 'DatePicker-dates',
    component: 'DatePicker',
    componentProps: {
      type: 'dates',
      valueFormat: 'YYYY-MM-DD'
    },
  },
  {
    field: 'datetime',
    title: 'DatePicker-datetime',
    component: 'DatePicker',
    componentProps: {
      type: 'datetime',
      valueFormat: 'YYYY-MM-DD HH:mm:ss'
    },
  },
  {
    field: 'week',
    title: 'DatePicker-week',
    component: 'DatePicker',
    componentProps: {
      type: 'week'
    },
  },
  {
    field: 'datetimerange',
    title: 'datetimerange',
    component: 'DatePicker',
    componentProps: {
      type: 'datetimerange',
      valueFormat: 'YYYY-MM-DD HH:mm:ss'
    },
  },
  {
    field: 'daterange',
    title: 'daterange',
    component: 'DatePicker',
    componentProps: {
      type: 'daterange',
      valueFormat: 'YYYY-MM-DD'
    },
  },
  {
    field: 'monthrange',
    title: 'monthrange',
    component: 'DatePicker',
    componentProps: {
      type: 'monthrange',
      valueFormat: 'YYYY-MM'
    },
  },
  {
    field: 'timepicker',
    title: 'TimePicker',
    component: 'TimePicker',
    componentProps: {
      valueFormat: 'HH:mm:ss'
    },
  },
  {
    field: 'timerange',
    title: 'TimePicker-range',
    component: 'TimePicker',
    componentProps: {
      isRange: true,
      valueFormat: 'HH:mm:ss'
    },
  },
  {
    field: 'timeSelect',
    title: 'TimeSelect',
    component: 'TimeSelect',
    componentProps: {
      isRange: true,
      valueFormat: 'HH:mm:ss'
    },
  },
];



export const uploadFormSchema: FormSchema[] = [
  {
    field: 'file',
    title: 'UploadText',
    component: 'Upload',
    componentProps: {
      listType: 'text',
      data: {
        billId: '123456'
      }
    },
  },
  {
    field: 'file2',
    title: 'UploadCard',
    component: 'Upload',
    componentProps: {
      listType: 'card',
      data: {
        billId: '123456'
      }
    },
  }
];
